/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.plugin.Plugin;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.HealthAndEnergyManager;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.MathEval;
import org.skills.utils.xseries.XSound;

public final class XPAndEnchantmentManager
implements Listener {
    protected static final Map<UUID, Integer> EXPS = new HashMap<UUID, Integer>();

    public static void onDisable() {
        for (Map.Entry<UUID, Integer> entry : EXPS.entrySet()) {
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null) {
                return;
            }
            player.setTotalExperience(entry.getValue().intValue());
        }
        EXPS.clear();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onEnchantmentTableOpen(InventoryOpenEvent inventoryOpenEvent) {
        if (!(inventoryOpenEvent.getPlayer() instanceof Player)) {
            return;
        }
        InventoryType inventoryType = inventoryOpenEvent.getView().getType();
        if (inventoryType != InventoryType.ENCHANTING && inventoryType != InventoryType.ANVIL) {
            return;
        }
        if (SkillsConfig.VANILLA_EXP_BAR_ENABLED.getBoolean() && !SkillsConfig.VANILLA_EXP_BAR_REAL_SYNC.getBoolean()) {
            Player player = (Player)inventoryOpenEvent.getPlayer();
            int n = EXPS.getOrDefault(player.getUniqueId(), player.getTotalExperience());
            player.setTotalExperience(0);
            player.giveExp(n);
        }
    }

    static double getCost(Player player, int n, int n2, SkillsConfig skillsConfig) {
        String string = skillsConfig.getString();
        if (string == null || string.isEmpty() || string.equals("0")) {
            return 0.0;
        }
        string = MessageHandler.replaceVariables(string, "lvl", n, "cost", n2);
        string = ServiceHandler.translatePlaceholders((OfflinePlayer)player, string);
        return MathEval.evaluate(string);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onEnchant(EnchantItemEvent enchantItemEvent) {
        Player player = enchantItemEvent.getEnchanter();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        Integer n = (Integer)enchantItemEvent.getEnchantsToAdd().entrySet().iterator().next().getValue();
        int n2 = enchantItemEvent.getExpLevelCost();
        int n3 = (int)XPAndEnchantmentManager.getCost(player, n, n2, SkillsConfig.ENCHANTMENT_TABLES_ADDITIONAL_COSTS_SKILL_LEVEL);
        double d = XPAndEnchantmentManager.getCost(player, n, n2, SkillsConfig.ENCHANTMENT_TABLES_ADDITIONAL_COSTS_SKILL_XP);
        long l = (long)XPAndEnchantmentManager.getCost(player, n, n2, SkillsConfig.ENCHANTMENT_TABLES_ADDITIONAL_COSTS_SOULS);
        if (n3 >= 0) {
            if (skilledPlayer.getLevel() >= n3) {
                skilledPlayer.setLevel(skilledPlayer.getLevel() - n3);
            } else {
                XSound.BLOCK_NOTE_BLOCK_BASS.record().soundPlayer().forPlayers(player).play();
                SkillsLang.ENCHANTMENTS_COSTS_NOT_ENOUGH_SKILL_LEVEL.sendMessage(player, "%amount%", n3);
                enchantItemEvent.setCancelled(true);
                return;
            }
        }
        if (d >= 0.0) {
            if (skilledPlayer.getXP() >= d) {
                skilledPlayer.addXP(-d);
            } else {
                XSound.BLOCK_NOTE_BLOCK_BASS.record().soundPlayer().forPlayers(player).play();
                SkillsLang.ENCHANTMENTS_COSTS_NOT_ENOUGH_SKILL_XP.sendMessage(player, "%amount%", d);
                enchantItemEvent.setCancelled(true);
                return;
            }
        }
        if (l >= 0L) {
            if (skilledPlayer.getSouls() >= l) {
                skilledPlayer.addSouls(-l);
            } else {
                XSound.BLOCK_NOTE_BLOCK_BASS.record().soundPlayer().forPlayers(player).play();
                SkillsLang.ENCHANTMENTS_COSTS_NOT_ENOUGH_SOULS.sendMessage(player, "%amount%", l);
                enchantItemEvent.setCancelled(true);
            }
        }
    }

    static int getExpFromLevel(int n) {
        if (n >= 32) {
            return (int)(4.5 * (double)n * (double)n - 162.5 * (double)n + 2220.0);
        }
        if (n >= 17) {
            return (int)(2.5 * (double)n * (double)n - 40.5 * (double)n + 360.0);
        }
        return n * n + 6 * n;
    }

    static int getLevelFromExp(long l) {
        if (l > 1395L) {
            return (int)Math.floor((Math.sqrt(72L * l - 54215L) + 325.0) / 18.0);
        }
        if (l > 315L) {
            return (int)Math.floor(Math.sqrt(40L * l - 7839L) / 10.0 + 8.1);
        }
        if (l > 0L) {
            return (int)Math.floor(Math.sqrt(l + 9L) - 3.0);
        }
        return 0;
    }

    static int getExpDiffFrom(int n, int n2) {
        if (n2 > n) {
            throw new IllegalArgumentException(n + " < " + n2);
        }
        if (n - n2 <= 0) {
            throw new IllegalArgumentException(n + " - " + n2);
        }
        return XPAndEnchantmentManager.getExpFromLevel(n) - XPAndEnchantmentManager.getExpFromLevel(n - n2);
    }

    static int getExpToNext(int n) {
        if (n > 30) {
            return 9 * n - 158;
        }
        if (n > 15) {
            return 5 * n - 38;
        }
        return 2 * n + 7;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEnchantFinalizeEXP(EnchantItemEvent enchantItemEvent) {
        Player player = enchantItemEvent.getEnchanter();
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
            int n = XPAndEnchantmentManager.getExpToNext(player.getLevel());
            int n2 = (int)((float)n * player.getExp());
            int n3 = XPAndEnchantmentManager.getExpFromLevel(player.getLevel()) + n2;
            EXPS.put(enchantItemEvent.getEnchanter().getUniqueId(), n3);
        }, 1L);
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent playerDeathEvent) {
        Player player;
        Integer n;
        if (SkillsConfig.VANILLA_EXP_BAR_ENABLED.getBoolean() && !SkillsConfig.VANILLA_EXP_BAR_REAL_SYNC.getBoolean() && (n = EXPS.remove((player = playerDeathEvent.getEntity()).getUniqueId())) != null) {
            playerDeathEvent.setDroppedExp(n.intValue());
        }
    }

    @EventHandler
    public void onEnchantTableReturnFakeXP(InventoryCloseEvent inventoryCloseEvent) {
        InventoryType inventoryType = inventoryCloseEvent.getView().getType();
        if (inventoryType != InventoryType.ENCHANTING && inventoryType != InventoryType.ANVIL) {
            return;
        }
        if (!(inventoryCloseEvent.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)inventoryCloseEvent.getPlayer();
        HealthAndEnergyManager.updateXPBar(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onExpBar(PlayerExpChangeEvent playerExpChangeEvent) {
        if (!SkillsConfig.VANILLA_EXP_BAR_ENABLED.getBoolean()) {
            return;
        }
        UUID uUID = playerExpChangeEvent.getPlayer().getUniqueId();
        EXPS.put(uUID, EXPS.getOrDefault(uUID, playerExpChangeEvent.getPlayer().getTotalExperience()) + playerExpChangeEvent.getAmount());
        playerExpChangeEvent.setAmount(0);
    }
}

