/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers;

import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.skills.data.managers.SkilledPlayer;
import org.skills.managers.DamageManager;
import org.skills.types.StatType;
import org.skills.utils.MathUtils;

public final class StatManager
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void statHandler(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        SkilledPlayer skilledPlayer;
        Entity entity = entityDamageByEntityEvent.getEntity();
        Player player = DamageManager.getOwningPlayer(entityDamageByEntityEvent.getDamager());
        if (player == null && !(entity instanceof Player)) {
            return;
        }
        double d = 0.0;
        if (player != null) {
            skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
            d += StatType.DAMAGE.evaluate(skilledPlayer);
            if (MathUtils.hasChance((int)StatType.CRITICAL_CHANCE.evaluate(skilledPlayer))) {
                d += StatType.CRITICAL_DAMAGE.evaluate(skilledPlayer);
            }
        }
        if (entity instanceof Player) {
            skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)entity);
            d -= StatType.DEFENSE.evaluate(skilledPlayer);
        }
        entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + d);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        double d = StatType.SPEED.evaluate(skilledPlayer);
        if (d == 0.0) {
            return;
        }
        player.setWalkSpeed((float)d);
    }
}

