/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.HealthAndEnergyManager;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.Cooldown;
import org.skills.utils.MathUtils;
import org.skills.utils.NoEpochDate;
import org.skills.utils.StringUtils;
import org.skills.utils.nbt.ItemNBT;
import org.skills.utils.nbt.NBTType;
import org.skills.utils.nbt.NBTWrappers;
import org.skills.utils.xseries.XEntityType;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public final class SkillItemManager
implements Listener {
    public static final String SKILL_ITEM = "Skill_Item";
    private static final String XP = "SKILLS_XP";

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void proj(ProjectileLaunchEvent projectileLaunchEvent) {
        Projectile projectile = projectileLaunchEvent.getEntity();
        if (projectile.getType() != XEntityType.EXPERIENCE_BOTTLE.get()) {
            return;
        }
        if (!(projectile.getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)projectile.getShooter();
        NBTWrappers.NBTTagCompound nBTTagCompound = ItemNBT.getTag(player.getItemInHand());
        String string = nBTTagCompound.get(SKILL_ITEM, NBTType.STRING);
        if (string == null || !string.startsWith("XP:")) {
            return;
        }
        String string2 = string.substring(3);
        projectile.setMetadata(XP, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)string2));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onConsume(PlayerItemConsumeEvent playerItemConsumeEvent) {
        ItemStack itemStack = playerItemConsumeEvent.getItem();
        NBTWrappers.NBTTagCompound nBTTagCompound = ItemNBT.getTag(itemStack);
        String string = nBTTagCompound.get(SKILL_ITEM, NBTType.STRING);
        if (string == null || !string.startsWith("ENERGY_")) {
            return;
        }
        Player player = playerItemConsumeEvent.getPlayer();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        boolean bl = string.startsWith("ENERGY_POTION");
        String string2 = StringUtils.deleteWhitespace(bl ? string.substring(14) : string.substring(15));
        if (bl) {
            int n = (int)MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders((OfflinePlayer)player, string2));
            skilledPlayer.chargeEnergy(n);
            ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.WITCH).withLocation(player.getLocation());
            particleDisplay.count = 50;
            particleDisplay.offset(0.5, 0.5, 0.5).spawn();
        } else {
            String[] stringArray = StringUtils.split((String)string2, (char)',');
            int n = (int)MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders((OfflinePlayer)player, stringArray[0]));
            long l = Long.parseLong(stringArray[1]);
            skilledPlayer.setEnergyBooster(n);
            SkillsLang.SKILLS_ITEM_ENERGY_BOOSTER.sendMessage(player, "%booster%", n, "%time%", new NoEpochDate(l, TimeUnit.SECONDS).format(SkillsConfig.TIME_FORMAT.getString()));
            new Cooldown(player.getUniqueId(), "ENERGY_BOOSTER", l, TimeUnit.SECONDS);
            XSound.BLOCK_BEACON_ACTIVATE.play((Entity)player);
        }
    }

    @EventHandler
    public void onHit(ExpBottleEvent expBottleEvent) {
        ThrownExpBottle thrownExpBottle = expBottleEvent.getEntity();
        List list = thrownExpBottle.getMetadata(XP);
        if (list.isEmpty()) {
            return;
        }
        expBottleEvent.setExperience(0);
        Player player = (Player)thrownExpBottle.getShooter();
        XSound.ENTITY_EXPERIENCE_ORB_PICKUP.play((Entity)player);
        String string = ((MetadataValue)list.get(0)).asString();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        int n = (int)MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders((OfflinePlayer)player, string));
        skilledPlayer.addXP(n);
        HealthAndEnergyManager.updateStats(player);
    }
}

