/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers;

import java.time.Duration;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.skills.utils.LocationUtils;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XTag;

public final class MoveManager
implements Listener {
    private static final Map<UUID, PlayerLocationState> LAST_GROUND_TIME = new HashMap<UUID, PlayerLocationState>();
    private static final Map<XMaterial, Double> BLOCK_HEIGHTS = new EnumMap<XMaterial, Double>(XMaterial.class);
    private static final List<Consumer<Player>> ON_PLAYER_HIT_GROUND_LISTENERS;

    public static void registerPlayerHitGround(Consumer<Player> consumer) {
        Objects.requireNonNull(consumer);
        ON_PLAYER_HIT_GROUND_LISTENERS.add(consumer);
    }

    public static Duration getLastTimeOnGround(Player player) {
        PlayerLocationState playerLocationState = LAST_GROUND_TIME.get(player.getUniqueId());
        if (playerLocationState == null) {
            return Duration.ZERO;
        }
        return Duration.ofMillis(System.currentTimeMillis()).minusMillis(playerLocationState.lastGroundTime);
    }

    public static boolean isMoving(Player player) {
        PlayerLocationState playerLocationState = LAST_GROUND_TIME.get(player.getUniqueId());
        if (playerLocationState == null) {
            return false;
        }
        long l = System.currentTimeMillis();
        long l2 = l - playerLocationState.lastMove;
        return l2 <= 500L;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onMove(PlayerMoveEvent playerMoveEvent) {
        if (!LocationUtils.hasMoved(playerMoveEvent.getFrom(), playerMoveEvent.getTo())) {
            return;
        }
        UUID uUID = playerMoveEvent.getPlayer().getUniqueId();
        PlayerLocationState playerLocationState = LAST_GROUND_TIME.get(uUID);
        if (playerLocationState == null) {
            playerLocationState = new PlayerLocationState();
            LAST_GROUND_TIME.put(uUID, playerLocationState);
        }
        long l = System.currentTimeMillis();
        if (playerMoveEvent.getTo().getY() % 1.0 == 0.0) {
            if (!playerLocationState.wasOnGroundLastTime) {
                for (Consumer<Player> consumer : ON_PLAYER_HIT_GROUND_LISTENERS) {
                    consumer.accept(playerMoveEvent.getPlayer());
                }
            }
            playerLocationState.lastGroundTime = l;
            playerLocationState.wasOnGroundLastTime = true;
        } else {
            playerLocationState.wasOnGroundLastTime = false;
        }
        playerLocationState.lastMove = l;
    }

    static {
        for (XMaterial xMaterial : XTag.CARPETS.getValues()) {
            BLOCK_HEIGHTS.put(xMaterial, 0.0625);
        }
        BLOCK_HEIGHTS.put(XMaterial.DIRT_PATH, 0.9375);
        BLOCK_HEIGHTS.put(XMaterial.FARMLAND, 0.9375);
        BLOCK_HEIGHTS.put(XMaterial.HONEY_BLOCK, 0.9375);
        BLOCK_HEIGHTS.put(XMaterial.CACTUS, 0.9375);
        BLOCK_HEIGHTS.put(XMaterial.BELL, 0.9375);
        BLOCK_HEIGHTS.put(XMaterial.BIG_DRIPLEAF_STEM, 0.9375);
        for (XMaterial xMaterial : XTag.BEDS.getValues()) {
            BLOCK_HEIGHTS.put(xMaterial, 0.5625);
        }
        BLOCK_HEIGHTS.put(XMaterial.STONECUTTER, 0.5625);
        BLOCK_HEIGHTS.put(XMaterial.CHAIN, 0.59375);
        BLOCK_HEIGHTS.put(XMaterial.REPEATER, 0.125);
        BLOCK_HEIGHTS.put(XMaterial.COMPARATOR, 0.125);
        ON_PLAYER_HIT_GROUND_LISTENERS = new ArrayList<Consumer<Player>>();
    }

    public static final class PlayerLocationState {
        public long lastGroundTime;
        public boolean wasOnGroundLastTime = true;
        public long lastMove;
    }
}

