/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.MessageHandler;
import org.skills.services.manager.ServiceHandler;
import org.skills.types.Stat;
import org.skills.utils.FireworkUtil;
import org.skills.utils.MathUtils;
import org.skills.utils.StringUtils;
import org.skills.utils.xseries.XEntityType;
import org.skills.utils.xseries.messages.Titles;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.Particles;
import org.skills.utils.xseries.particles.XParticle;

public class LevelUp {
    private final ConfigurationSection section;
    private int xp;
    private int souls;
    private int statPoints;
    private List<String> commands;
    private OfflinePlayer player;
    private SkilledPlayer info;
    private int lvl;

    private LevelUp(ConfigurationSection configurationSection) {
        this.section = configurationSection;
        this.commands = configurationSection.getStringList("commands");
    }

    public static int getLevel(SkilledPlayer skilledPlayer, int n) {
        return LevelUp.getProperties((int)n).forPlayer((OfflinePlayer)skilledPlayer.getOfflinePlayer()).evaluateRewards().xp;
    }

    public static LevelUp getProperties(int n) {
        Validate.isTrue((n >= 0 ? 1 : 0) != 0, (String)"No levelup properties for levels lower than 0");
        ConfigurationSection configurationSection = SkillsConfig.LEVELS.getSection();
        ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(String.valueOf(n));
        if (configurationSection2 == null) {
            Set<String> set = SkillsConfig.LEVELS.getSectionSet();
            int n2 = 0;
            for (String string : set) {
                int n3 = NumberUtils.toInt((String)string, (int)n2);
                if (n3 > n && n2 <= n) {
                    configurationSection2 = configurationSection.getConfigurationSection(String.valueOf(n2));
                    break;
                }
                n2 = n3;
            }
            if (configurationSection2 == null) {
                configurationSection2 = configurationSection.getConfigurationSection(String.valueOf(n2));
            }
        }
        return new LevelUp(configurationSection2).level(n);
    }

    public LevelUp forPlayer(OfflinePlayer offlinePlayer) {
        this.player = offlinePlayer;
        this.info = SkilledPlayer.getSkilledPlayer(offlinePlayer);
        return this;
    }

    public LevelUp level(int n) {
        this.lvl = n;
        return this;
    }

    public LevelUp performRewards() {
        this.info.addSouls(this.souls);
        this.info.addStat(Stat.POINTS, this.statPoints);
        Player player = this.info.getPlayer();
        for (String string : this.commands) {
            ConsoleCommandSender consoleCommandSender;
            Object object = consoleCommandSender = string.toUpperCase().startsWith("CONSOLE:") ? Bukkit.getConsoleSender() : player;
            if (consoleCommandSender == player && player == null) continue;
            int n = string.indexOf(58);
            String string2 = string.substring(n + 1);
            Bukkit.dispatchCommand((CommandSender)consoleCommandSender, (String)string2);
        }
        return this;
    }

    public LevelUp performMessages() {
        OfflinePlayer offlinePlayer = this.info.getOfflinePlayer();
        if (offlinePlayer.isOnline()) {
            ConfigurationSection configurationSection;
            Player player = (Player)offlinePlayer;
            Object[] objectArray = new Object[]{"%lvl%", this.lvl, "%xp_required%", StringUtils.toFancyNumber(this.xp), "%gained_stats%", StringUtils.toFancyNumber(this.statPoints), "%gained_souls%", StringUtils.toFancyNumber(this.souls), "%next_maxxp%", StringUtils.toFancyNumber(this.info.getLevelXP(this.lvl))};
            String string = this.section.getString("message");
            if (!Strings.isNullOrEmpty((String)string)) {
                player.sendMessage(this.translateMessage(string, objectArray));
            }
            if ((configurationSection = this.section.getConfigurationSection("title")) != null) {
                String string2;
                String string3 = configurationSection.getString("title");
                if (!Strings.isNullOrEmpty((String)string3)) {
                    string3 = this.translateMessage(string3, objectArray);
                }
                if (!Strings.isNullOrEmpty((String)(string2 = configurationSection.getString("subtitle")))) {
                    string2 = this.translateMessage(string2, objectArray);
                }
                Titles.sendTitle(player, configurationSection.getInt("fade-in"), configurationSection.getInt("stay"), configurationSection.getInt("fade-out"), string3, string2);
            }
        }
        return this;
    }

    private String translateMessage(String string, Object ... objectArray) {
        return MessageHandler.colorize(MessageHandler.replaceVariables(ServiceHandler.translatePlaceholders(this.player, string), objectArray));
    }

    private int eval(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return 0;
        }
        return (int)Math.round(MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders(this.player, StringUtils.replace((String)string, (String)"lvl", (String)String.valueOf(this.lvl)))));
    }

    public void celebrate(Player player, JavaPlugin javaPlugin) {
        ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.CRIT).withLocation(player.getLocation());
        int n = Math.min(Math.max(5, this.lvl / 2), 15);
        Particles.dnaReplication((Plugin)javaPlugin, 1.0, 0.2, 3, 1.0, n, 2, particleDisplay);
        int n2 = MathUtils.randInt(2, 5);
        int n3 = Math.max(1, this.lvl / 2);
        for (int i = 0; i < n2; ++i) {
            Firework firework = (Firework)player.getWorld().spawnEntity(player.getLocation(), XEntityType.FIREWORK_ROCKET.get());
            FireworkMeta fireworkMeta = firework.getFireworkMeta();
            FireworkUtil.generateFireworkMeta(fireworkMeta, n3);
            if (n > 10) {
                fireworkMeta.setPower(1);
            }
            firework.setMetadata("LVLUP", (MetadataValue)new FixedMetadataValue((Plugin)javaPlugin, null));
            firework.setFireworkMeta(fireworkMeta);
        }
    }

    public LevelUp add(LevelUp levelUp) {
        this.xp += levelUp.xp;
        this.souls += levelUp.souls;
        this.statPoints += levelUp.statPoints;
        this.commands.addAll(levelUp.commands);
        return this;
    }

    public LevelUp evaluateRewards() {
        this.xp = this.eval(this.section.getString("xp"));
        this.souls = this.eval(this.section.getString("souls"));
        this.statPoints = this.eval(this.section.getString("statpoints"));
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.commands != null) {
            for (String string : this.commands) {
                arrayList.add(this.translateMessage(string, new Object[0]));
            }
        }
        this.commands = arrayList;
        return this;
    }
}

