/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers;

import com.google.common.base.Enums;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.skills.abilities.Ability;
import org.skills.api.events.CustomHudChangeEvent;
import org.skills.api.events.SkillLevelUpEvent;
import org.skills.api.events.SkillSoulGainEvent;
import org.skills.api.events.SkillXPGainEvent;
import org.skills.data.managers.PlayerDataManager;
import org.skills.data.managers.SkilledPlayer;
import org.skills.events.SkillsBonus;
import org.skills.events.SkillsEventType;
import org.skills.main.SLogger;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.DamageManager;
import org.skills.managers.HealthAndEnergyManager;
import org.skills.managers.LevelUp;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.BooleanEval;
import org.skills.utils.Hologram;
import org.skills.utils.MathUtils;
import org.skills.utils.Pair;
import org.skills.utils.StringUtils;

public final class LevelManager
implements Listener {
    protected static final String SPAWNER = "SPAWNER";
    private static final List<CustomAmount> CUSTOM_XP = new ArrayList<CustomAmount>();
    private static final List<CustomAmount> CUSTOM_SOULS = new ArrayList<CustomAmount>();
    private final SkillsPro plugin;

    public LevelManager(SkillsPro skillsPro) {
        this.plugin = skillsPro;
        MessageHandler.sendConsolePluginMessage("&3Setting up Level Manager...");
        LevelManager.load(skillsPro);
    }

    public static boolean evaluate(Player player, double d, List<String> list) {
        for (String string : list) {
            String string2 = ServiceHandler.translatePlaceholders((OfflinePlayer)player, string);
            if (!BooleanEval.evaluate(string2 = StringUtils.replace((String)string2, (String)"%level%", (String)String.valueOf(d)), null)) continue;
            return true;
        }
        return false;
    }

    public static List<Player> partyMembersInRange(Player player, SkilledPlayer skilledPlayer) {
        double d = SkillsConfig.PARTY_MEMBERS_MAX_DISTANCE.getDouble();
        if (d < 1.0) {
            return skilledPlayer.getParty().getOnlineMembers();
        }
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Entity entity : player.getNearbyEntities(d, d, d)) {
            if (!(entity instanceof Player)) continue;
            Player player2 = (Player)entity;
            SkilledPlayer skilledPlayer2 = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player2);
            if (!skilledPlayer.getPartyId().equals(skilledPlayer2.getPartyId())) continue;
            arrayList.add(player2);
        }
        return arrayList;
    }

    public static void onLevelUp(SkillLevelUpEvent skillLevelUpEvent) {
        Player player = skillLevelUpEvent.getPlayer();
        int n = skillLevelUpEvent.getNewLevel();
        PlayerDataManager.addLevel((OfflinePlayer)player, n);
        LevelUp levelUp = skillLevelUpEvent.getLevelProperties().level(n).forPlayer((OfflinePlayer)player).evaluateRewards().performMessages().performRewards();
        if (SkillsConfig.LEVEL_CELEBRATION.getBoolean()) {
            levelUp.celebrate(player, SkillsPro.get());
        }
        HealthAndEnergyManager.updateStats(player);
    }

    public static void load(JavaPlugin javaPlugin) {
        Object object;
        Object object2;
        Object object3;
        CUSTOM_XP.clear();
        ConfigurationSection configurationSection = SkillsConfig.XP.getSection();
        if (configurationSection == null) {
            MessageHandler.sendConsolePluginMessage("&4Outdated config.yml missing XP and Souls section.");
            MessageHandler.sendConsolePluginMessage("&4Custom XP and souls will not be loaded.");
            return;
        }
        for (Object object4 : configurationSection.getKeys(false)) {
            String string = configurationSection.getString((String)object4);
            object3 = null;
            if (((String)object4).startsWith("TYPE:")) {
                object2 = CustomAmount.CustomAmounType.TYPE;
                object = StringUtils.deleteWhitespace(((String)(object4 = ((String)object4).substring(5))).toUpperCase(Locale.ENGLISH));
                object3 = (EntityType)Enums.getIfPresent(EntityType.class, (String)object).orNull();
                if (object3 == null) {
                    MessageHandler.sendConsolePluginMessage("&cInvalid entity type specified for XP&8: &e" + (String)object + " &cin &e" + (String)object4);
                    continue;
                }
            } else if (((String)object4).startsWith("CUSTOM:")) {
                object4 = ((String)object4).substring(7);
                object2 = CustomAmount.CustomAmounType.CUSTOM_MOB;
            } else if (((String)object4).startsWith("CONTAINS:")) {
                object4 = ((String)object4).substring(9);
                object2 = CustomAmount.CustomAmounType.CONTAINS;
            } else {
                object4 = MessageHandler.colorize((String)object4);
                object2 = CustomAmount.CustomAmounType.NAME;
            }
            object = new CustomAmount((String)object4, string, (EntityType)object3, (CustomAmount.CustomAmounType)((Object)object2));
            CUSTOM_XP.add((CustomAmount)object);
        }
        CUSTOM_SOULS.clear();
        ConfigurationSection configurationSection2 = javaPlugin.getConfig().getConfigurationSection("souls");
        for (String string : configurationSection2.getKeys(false)) {
            Object object5;
            object2 = configurationSection2.getString(string);
            object = null;
            if (string.startsWith("TYPE:")) {
                object3 = CustomAmount.CustomAmounType.TYPE;
                object5 = StringUtils.deleteWhitespace((string = string.substring(5)).toUpperCase(Locale.ENGLISH));
                object = (EntityType)Enums.getIfPresent(EntityType.class, (String)object5).orNull();
                if (object == null) {
                    MessageHandler.sendConsolePluginMessage("&cInvalid entity type specified for XP&8: &e" + (String)object5 + " &cin &e" + string);
                    continue;
                }
            } else if (string.startsWith("CUSTOM:")) {
                string = string.substring(7);
                object3 = CustomAmount.CustomAmounType.CUSTOM_MOB;
            } else if (string.startsWith("CONTAINS:")) {
                string = string.substring(9);
                object3 = CustomAmount.CustomAmounType.CONTAINS;
            } else {
                string = MessageHandler.colorize(string);
                object3 = CustomAmount.CustomAmounType.NAME;
            }
            object5 = new CustomAmount(string, (String)object2, (EntityType)object, (CustomAmount.CustomAmounType)((Object)object3));
            CUSTOM_SOULS.add((CustomAmount)object5);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onKillGains(EntityDeathEvent entityDeathEvent) {
        Object object;
        Object object2;
        Player player;
        Object object3;
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        SLogger.debug(() -> "An entity was killed " + livingEntity + " (" + livingEntity.getType() + ")  | " + DamageManager.getKiller(entityDeathEvent) + " | " + Ability.isSkillEntity((Entity)livingEntity) + " | " + ServiceHandler.isKingdomMob(livingEntity) + " | " + SkillsConfig.isInDisabledWorld(livingEntity.getWorld()));
        if (livingEntity.getType() == EntityType.ARMOR_STAND) {
            return;
        }
        LivingEntity livingEntity2 = DamageManager.getKiller(entityDeathEvent);
        if (!(livingEntity2 instanceof Player)) {
            return;
        }
        if (Ability.isSkillEntity((Entity)livingEntity)) {
            return;
        }
        if (ServiceHandler.isKingdomMob(livingEntity)) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(livingEntity.getWorld())) {
            return;
        }
        Player player2 = (Player)livingEntity2;
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player2);
        Pair<String, Number> pair = ServiceHandler.getMobProperties(livingEntity);
        SLogger sLogger = new SLogger();
        sLogger.add(() -> "&c" + player2.getName() + " &6killed &2" + livingEntity.getName() + " &8(&2" + livingEntity.getCustomName() + "&7-&2" + livingEntity.getType() + "&8) &6with custom property &2" + pair + " &6and vanilla EXP of &2" + entityDeathEvent.getDroppedExp());
        double d = 0.0;
        if (player2.hasPermission("skills.xp") && !SkillsConfig.DISABLED_WORLDS_XP_GAIN.getStringList().contains(player2.getWorld().getName())) {
            double d2;
            d = MathUtils.evaluateEquation(MessageHandler.replace(SkillsConfig.DEFAULT_XP.getString(), "lvl", pair == null ? 1.0 : pair.getValue().doubleValue()));
            for (CustomAmount object4 : CUSTOM_XP) {
                boolean bl = object4.matches(livingEntity, pair);
                sLogger.add(() -> "Matching XP " + object4 + " returned: " + bl);
                if (!bl) continue;
                d = object4.evaluate(player2, pair);
                break;
            }
            if (d == -1.0) {
                d = entityDeathEvent.getDroppedExp();
                sLogger.add(() -> "No custom XP defined for this entity, using the default XP which is " + entityDeathEvent.getDroppedExp());
            }
            d *= SkillsBonus.getMultiplierFor(player2, SkillsEventType.XP);
            if (skilledPlayer.hasParty()) {
                List<Player> list = LevelManager.partyMembersInRange(player2, skilledPlayer);
                String n2 = StringUtils.replace((String)StringUtils.replace((String)ServiceHandler.translatePlaceholders((OfflinePlayer)player2, SkillsConfig.PARTY_XP_PER_MEMBER.getString()), (String)"xp", (String)String.valueOf(d)), (String)"members-in-range", (String)String.valueOf(list.size()));
                double d3 = MathUtils.evaluateEquation(n2);
                if (SkillsConfig.PARTY_DISTRIBUTE.getBoolean()) {
                    object3 = list.iterator();
                    while (object3.hasNext()) {
                        player = (Player)object3.next();
                        object2 = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
                        object = new SkillXPGainEvent(player, (Entity)livingEntity, d3);
                        Bukkit.getPluginManager().callEvent((Event)object);
                        if (((SkillXPGainEvent)((Object)object)).isCancelled()) continue;
                        ((SkilledPlayer)object2).addXP(d3);
                    }
                } else {
                    d += d3;
                }
            }
            if (pair != null && SkillsConfig.MYTHICMOBS_WORLDS_WITH_LEVEL_MARGIN.getStringList().contains(livingEntity.getWorld().getName()) && LevelManager.evaluate(player2, d2 = pair.getValue().doubleValue(), SkillsConfig.MYTHICMOBS_XP_CONDITIONS.getStringList())) {
                d = 0.0;
            }
            for (PermissionAttachmentInfo permissionAttachmentInfo : player2.getEffectivePermissions()) {
                String string;
                if (!permissionAttachmentInfo.getValue() || !(string = permissionAttachmentInfo.getPermission()).startsWith("skills.xp.")) continue;
                string = string.substring(10);
                double d4 = NumberUtils.toDouble((String)string, (double)1.0);
                d *= d4;
            }
            if (livingEntity.hasMetadata(SPAWNER)) {
                d = (int)SkillsConfig.SPAWNERS_XP.fromEquation((OfflinePlayer)player2, "%xp%", d);
            }
            if (d != 0.0 && !SkillsConfig.DISABLED_WORLDS_XP_GAIN.getStringList().contains(livingEntity.getWorld().getName())) {
                SkillXPGainEvent skillXPGainEvent = new SkillXPGainEvent(player2, (Entity)livingEntity, d);
                Bukkit.getPluginManager().callEvent(skillXPGainEvent);
                if (!skillXPGainEvent.isCancelled()) {
                    if (d != skillXPGainEvent.getGained()) {
                        sLogger.add("Event changed the gained XP from " + d + " to " + skillXPGainEvent.getGained());
                    }
                    d = skillXPGainEvent.getGained();
                    skilledPlayer.addXP(d);
                }
            }
        }
        int n = 0;
        if (player2.hasPermission("skills.souls") && !SkillsConfig.DISABLED_WORLDS_XP_GAIN.getStringList().contains(player2.getWorld().getName())) {
            int n2;
            int n3;
            double d5;
            int n4;
            int n5;
            int n6 = (int)MathUtils.evaluateEquation(MessageHandler.replace(SkillsConfig.DEFAULT_SOULS.getString(), "lvl", pair == null ? 1.0 : pair.getValue().doubleValue()));
            for (CustomAmount customAmount : CUSTOM_SOULS) {
                sLogger.add(() -> "Matching souls '" + customAmount.matcher + "': '" + customAmount.equation + "' matches? " + customAmount.matches(livingEntity, pair) + " evaluated: " + customAmount.evaluate(player2, pair));
                if (!customAmount.matches(livingEntity, pair)) continue;
                n5 = (int)customAmount.evaluate(player2, pair);
                break;
            }
            if (skilledPlayer.hasParty()) {
                List<Player> list = LevelManager.partyMembersInRange(player2, skilledPlayer);
                String string = StringUtils.replace((String)StringUtils.replace((String)ServiceHandler.translatePlaceholders((OfflinePlayer)player2, SkillsConfig.PARTY_SOULS_PER_MEMBER.getString()), (String)"souls", (String)String.valueOf(n5)), (String)"members-in-range", (String)String.valueOf(list.size()));
                int n7 = (int)MathUtils.evaluateEquation(string);
                if (SkillsConfig.PARTY_DISTRIBUTE.getBoolean()) {
                    player = list.iterator();
                    while (player.hasNext()) {
                        object2 = (Player)player.next();
                        object = SkilledPlayer.getSkilledPlayer((OfflinePlayer)object2);
                        SkillSoulGainEvent skillSoulGainEvent = new SkillSoulGainEvent((Player)object2, (Entity)livingEntity, n5);
                        Bukkit.getPluginManager().callEvent((Event)skillSoulGainEvent);
                        if (skillSoulGainEvent.isCancelled()) continue;
                        ((SkilledPlayer)object).addSouls(skillSoulGainEvent.getGained());
                    }
                } else {
                    n4 = n5 + n7;
                }
            }
            void var11_21 = n4 * (int)SkillsBonus.getMultiplierFor(player2, SkillsEventType.SOUL);
            if (pair != null && SkillsConfig.MYTHICMOBS_WORLDS_WITH_LEVEL_MARGIN.getStringList().contains(livingEntity.getWorld().getName()) && LevelManager.evaluate(player2, d5 = pair.getValue().doubleValue(), SkillsConfig.MYTHICMOBS_SOUL_CONDITIONS.getStringList())) {
                boolean bl = false;
            }
            for (PermissionAttachmentInfo permissionAttachmentInfo : player2.getEffectivePermissions()) {
                if (!permissionAttachmentInfo.getValue() || !((String)(object3 = permissionAttachmentInfo.getPermission())).startsWith("skills.souls.")) continue;
                object3 = ((String)object3).substring(13);
                double d6 = NumberUtils.toDouble((String)object3, (double)1.0);
                n3 = (int)((double)n3 * d6);
            }
            if (livingEntity.hasMetadata(SPAWNER)) {
                n2 = (int)SkillsConfig.SPAWNERS_SOULS.fromEquation((OfflinePlayer)player2, "%souls%", n3);
            }
            if (n2 != 0 && !SkillsConfig.DISABLED_WORLDS_SOUL_GAIN.getStringList().contains(livingEntity.getWorld().getName())) {
                SkillSoulGainEvent skillSoulGainEvent = new SkillSoulGainEvent(player2, (Entity)livingEntity, n2);
                Bukkit.getPluginManager().callEvent(skillSoulGainEvent);
                if (!skillSoulGainEvent.isCancelled()) {
                    skilledPlayer.addSouls(skillSoulGainEvent.getGained());
                    n = skillSoulGainEvent.getGained();
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Ability ability : skilledPlayer.getSkill().getAbilities()) {
            int n8 = skilledPlayer.getAbilityLevel(ability);
            if (ability.getName().equals("passive") || n8 == 3) continue;
            int n9 = ability.getCost(skilledPlayer);
            if (skilledPlayer.getSouls() < (long)n9 || skilledPlayer.getSouls() - (long)n >= (long)n9) continue;
            stringBuilder.append(SkillsLang.ABILITY_UPGRADE_NOTIFICATION_LIST.parse(player2, new Object[]{"%ability%", ability.getTitle(skilledPlayer), "%ability_level%", n8 + 1}));
        }
        if (stringBuilder.length() != 0) {
            SkillsLang.ABILITY_UPGRADE_NOTIFICATION.sendMessage(player2, "%abilities%", stringBuilder);
        }
        double d7 = MathUtils.roundToDigits(d, 2);
        if (SkillsConfig.HOLOGRAM_ENABLED.getBoolean() && !SkillsConfig.HOLOGRAM_DISABLED_MOBS.getStringList().contains(livingEntity.getType().name())) {
            Hologram.spawn(livingEntity.getLocation().clone().add(0.0, -2.0, 0.0), SkillsConfig.HOLOGRAM_STAY.getLong(), SkillsConfig.HOLOGRAM_LINES.getStringList(), "%xp%", d7, "%souls%", n);
        }
        sLogger.add("Final XP: " + d + " Final souls: " + n);
        sLogger.show();
        if (SkillsConfig.KILL_MESSAGE.getBoolean()) {
            object3 = livingEntity.getCustomName() == null ? livingEntity.getName() : livingEntity.getCustomName();
            SkillsLang.KILL_MESSAGE.sendMessage(player2, "%xp%", d7, "%souls%", n, "%name%", object3);
        }
        CustomHudChangeEvent.call(player2);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onFireworkDamage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.getDamager() instanceof Firework) {
            Firework firework = (Firework)entityDamageByEntityEvent.getDamager();
            if (firework.hasMetadata("LVLUP")) {
                entityDamageByEntityEvent.setCancelled(true);
            }
        } else if (entityDamageByEntityEvent.getDamager() instanceof Player && SkillsConfig.HOLOGRAM_ENABLED.getBoolean() && !SkillsConfig.HOLOGRAM_DISABLED_MOBS.getStringList().contains(entityDamageByEntityEvent.getEntity().getType().name())) {
            Hologram.spawn(entityDamageByEntityEvent.getEntity().getLocation().add(0.0, -2.0, 0.0), SkillsConfig.HOLOGRAM_STAY.getLong(), SkillsConfig.HOLOGRAM_DAMAGE_INDICATOR.getStringList(), "%damage%", MathUtils.roundToDigits(entityDamageByEntityEvent.getFinalDamage(), SkillsConfig.HOLOGRAM_DAMAGE_INDICATOR_PRECISION.getInt()), "%direct_damage%", MathUtils.roundToDigits(entityDamageByEntityEvent.getDamage(), SkillsConfig.HOLOGRAM_DAMAGE_INDICATOR_PRECISION.getInt()));
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (skilledPlayer.getLevel() < SkillsConfig.LOSS_MIN_LEVEL.getInt()) {
            return;
        }
        long l = 0L;
        double d = 0.0;
        LivingEntity livingEntity = DamageManager.getKiller((EntityDeathEvent)playerDeathEvent);
        Pair<String, Number> pair = livingEntity != null ? ServiceHandler.getMobProperties(livingEntity) : null;
        if (skilledPlayer.getSouls() > 1L && !SkillsConfig.DISABLED_WORLDS_SOUL_LOSS.getStringList().contains(player.getWorld().getName())) {
            if (SkillsConfig.LOSE_SAME_SOULS_AS_KILLER_SOULS_GAIN.getBoolean()) {
                if (livingEntity != null) {
                    l = 1L;
                    for (CustomAmount customAmount : CUSTOM_SOULS) {
                        if (!customAmount.matches(livingEntity, pair)) continue;
                        l = (int)customAmount.evaluate(player, pair);
                        break;
                    }
                } else {
                    l = (int)MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders((OfflinePlayer)player, SkillsConfig.SOULS_LOSS_UPON_DEATH.getString()));
                }
            } else {
                l = (int)MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders((OfflinePlayer)player, SkillsConfig.SOULS_LOSS_UPON_DEATH.getString()));
            }
            skilledPlayer.setSouls(Math.max(0L, skilledPlayer.getSouls() - l));
        }
        if (skilledPlayer.getXP() > 1.0 && !SkillsConfig.DISABLED_WORLDS_XP_LOSS.getStringList().contains(player.getWorld().getName())) {
            if (SkillsConfig.LOSE_SAME_XP_AS_KILLER_XP_GAIN.getBoolean()) {
                if (livingEntity != null) {
                    d = -1.0;
                    for (CustomAmount customAmount : CUSTOM_XP) {
                        if (!customAmount.matches(livingEntity, pair)) continue;
                        d = customAmount.evaluate(player, pair);
                        break;
                    }
                    if (d == -1.0) {
                        d = playerDeathEvent.getDroppedExp();
                    }
                } else {
                    d = MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders((OfflinePlayer)player, SkillsConfig.XP_LOSS_UPON_DEATH.getString()));
                }
            } else {
                d = MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders((OfflinePlayer)player, SkillsConfig.XP_LOSS_UPON_DEATH.getString()));
            }
            skilledPlayer.setAbsoluteXP(Math.max(0.0, skilledPlayer.getXP() - d));
        }
        SkillsLang.DEATH.sendMessage(player, "%souls%", l, "%xp%", d);
    }

    @EventHandler
    public void mobSpawnEvent(CreatureSpawnEvent creatureSpawnEvent) {
        if (creatureSpawnEvent.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
            creatureSpawnEvent.getEntity().setMetadata(SPAWNER, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)""));
        }
    }

    private static final class CustomAmount {
        public CustomAmounType customAmounType;
        public EntityType type;
        public String matcher;
        public String equation;

        public CustomAmount(String string, String string2, EntityType entityType, CustomAmounType customAmounType) {
            this.matcher = customAmounType == CustomAmounType.CONTAINS ? string.toLowerCase() : string;
            this.type = entityType;
            this.customAmounType = customAmounType;
            this.equation = string2;
        }

        public boolean matches(LivingEntity livingEntity, Pair<String, Number> pair) {
            switch (this.customAmounType.ordinal()) {
                case 0: {
                    return livingEntity.getCustomName() != null && livingEntity.getCustomName().toLowerCase().contains(this.matcher);
                }
                case 1: {
                    return pair != null && pair.getKey() != null && this.matcher.equalsIgnoreCase(pair.getKey());
                }
                case 3: {
                    return livingEntity.getCustomName() != null && livingEntity.getCustomName().equalsIgnoreCase(this.matcher);
                }
                case 2: {
                    return livingEntity.getType() == this.type;
                }
            }
            throw new AssertionError((Object)("Unknown custom amount type: " + (Object)((Object)this.customAmounType)));
        }

        public String toString() {
            return "CustomAmount:{expression='" + this.matcher + "', type=" + this.type + ", customMobType=" + (Object)((Object)this.customAmounType) + ", equation='" + this.equation + "'}";
        }

        public double evaluate(Player player, Pair<String, Number> pair) {
            String string = ServiceHandler.translatePlaceholders((OfflinePlayer)player, this.equation);
            string = MessageHandler.replace(string, "lvl", pair == null ? 1.0 : pair.getValue().doubleValue());
            return MathUtils.evaluateEquation(string);
        }

        private static enum CustomAmounType {
            CONTAINS,
            CUSTOM_MOB,
            TYPE,
            NAME;

        }
    }
}

