/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.skills.api.events.CustomHudChangeEvent;
import org.skills.api.events.SkillXPGainEvent;
import org.skills.commands.general.CommandSelect;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.managers.DamageManager;
import org.skills.managers.XPAndEnchantmentManager;
import org.skills.services.manager.ServiceHandler;
import org.skills.types.Energy;
import org.skills.types.Skill;
import org.skills.types.SkillManager;
import org.skills.types.SkillScaling;
import org.skills.utils.Cooldown;
import org.skills.utils.StringUtils;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.messages.ActionBar;

public final class HealthAndEnergyManager
implements Listener {
    private static final Map<Integer, BossBar> LEVEL_BOSSBARS = new HashMap<Integer, BossBar>();

    public HealthAndEnergyManager(SkillsPro skillsPro) {
        int n;
        int n2 = SkillsConfig.ACTIONBAR_FREQUENCY.getInt();
        if (SkillsConfig.ACTIONBAR_ENABLED.getBoolean() && n2 > 0) {
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)skillsPro, () -> {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.hasPermission("skills.actionbar") || !SkilledPlayer.getSkilledPlayer((OfflinePlayer)player).showActionBar() || SkillsConfig.isInDisabledWorld(player.getLocation())) continue;
                    CustomHudChangeEvent customHudChangeEvent = new CustomHudChangeEvent(player);
                    Bukkit.getPluginManager().callEvent((Event)customHudChangeEvent);
                    if (customHudChangeEvent.isCancelled()) continue;
                    ActionBar.sendActionBar(player, customHudChangeEvent.getHud());
                }
            }, 100L, (long)n2);
        }
        if ((n = SkillsConfig.BOSSBAR_LEVELS_FREQUENCY.getInt()) > 0) {
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)skillsPro, () -> {
                String string = SkillsConfig.BOSSBAR_LEVELS.getSection().getString("title");
                for (Player player : Bukkit.getOnlinePlayers()) {
                    BossBar bossBar = LEVEL_BOSSBARS.get(player.getEntityId());
                    if (bossBar == null) continue;
                    bossBar.setTitle(MessageHandler.colorize(ServiceHandler.translatePlaceholders((OfflinePlayer)player, string)));
                }
            }, 100L, (long)n);
        }
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)skillsPro, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                SkilledPlayer skilledPlayer;
                if (SkillsConfig.isInDisabledWorld(player.getLocation()) || !(skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player)).hasSkill()) continue;
                Energy energy = skilledPlayer.getSkill().getEnergy();
                boolean bl = energy.hasChargingMethod(Energy.ChargingMethod.AUTO_REVERSE);
                boolean bl2 = energy.hasChargingMethod(Energy.ChargingMethod.AUTO_NO_DAMAGE);
                if (!energy.hasChargingMethod(Energy.ChargingMethod.AUTO) && !bl && !bl2) continue;
                double d = skilledPlayer.getEnergy();
                double d2 = skilledPlayer.getScaling(SkillScaling.ENERGY_REGEN);
                double d3 = d;
                if (bl) {
                    d3 = d - d2 <= 0.0 ? 0.0 : (d3 -= d2);
                } else {
                    if (bl2 && Cooldown.isInCooldown(player.getUniqueId(), "LAST_DAMAGE_AUTO_ENERGY")) continue;
                    if (!Cooldown.isInCooldown(player.getUniqueId(), "ENERGY_BOOSTER")) {
                        skilledPlayer.setEnergyBooster(0.0);
                    }
                    double d4 = skilledPlayer.getEnergyBooster();
                    d2 += d4;
                    double d5 = skilledPlayer.getScaling(SkillScaling.MAX_ENERGY);
                    if (d3 >= d5) continue;
                    d3 = d + d2 >= d5 ? d5 : (d3 += d2);
                    if (d3 >= d5) {
                        XSound.play(energy.getSoundFull(), soundPlayer -> soundPlayer.forPlayers(player));
                    }
                }
                if (!player.isOnline()) continue;
                skilledPlayer.setEnergy(d3);
            }
        }, 60L, 20L);
    }

    public static BossBar getBossBar(Player player) {
        return LEVEL_BOSSBARS.get(player.getEntityId());
    }

    public static float updateXPBar(Player player) {
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        float f = (float)(skilledPlayer.getXP() / skilledPlayer.getLevelXP(skilledPlayer.getLevel()));
        Validate.isTrue(((double)f <= 1.0 && (double)f >= 0.0 ? 1 : 0) != 0, (String)("Invalid BossBar percent for " + player.getName() + ": " + f + " -> XP: " + skilledPlayer.getXP() + ", Next Level XP: " + skilledPlayer.getLevelXP(skilledPlayer.getLevel()) + " for level " + skilledPlayer.getLevel()));
        if (SkillsConfig.VANILLA_EXP_BAR_ENABLED.getBoolean() && !SkillsConfig.VANILLA_EXP_BAR_REAL_SYNC.getBoolean() && SkillsConfig.VANILLA_EXP_BAR_ENABLED.getBoolean()) {
            int n;
            String string;
            switch (string = SkillsConfig.VANILLA_EXP_BAR_SHOWN_NUMBER.getString().toLowerCase(Locale.ENGLISH)) {
                case "xp": {
                    n = (int)skilledPlayer.getXP();
                    break;
                }
                case "level": {
                    n = skilledPlayer.getLevel();
                    break;
                }
                case "souls": {
                    n = (int)skilledPlayer.getSouls();
                    break;
                }
                default: {
                    MessageHandler.sendConsolePluginMessage("&4Invalid 'shown-number' option for vanilla EXP bar&8: &e" + string);
                    n = 0;
                }
            }
            player.setLevel(n);
            player.setExp(f);
        }
        return f;
    }

    public static void updateStats(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SkillsPro.get(), () -> {
            Skill skill;
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
            float f = HealthAndEnergyManager.updateXPBar(player);
            if (SkillsConfig.BOSSBAR_LEVELS_ENABLED.getBoolean() && player.hasPermission("skills.bossbar") && (skill = LEVEL_BOSSBARS.get(player.getEntityId())) != null) {
                skill.setTitle(MessageHandler.colorize(ServiceHandler.translatePlaceholders((OfflinePlayer)player, SkillsConfig.BOSSBAR_LEVELS.getSection().getString("title"))));
                skill.setProgress(f);
            }
            if (!skilledPlayer.hasSkill()) {
                return;
            }
            skill = skilledPlayer.getSkill();
            double d = skill.getScaling(skilledPlayer, SkillScaling.MAX_HEALTH);
            Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> VersionSupport.setMaxHealth((LivingEntity)player, d));
        });
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onHitEnergyCharge(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getEntity() instanceof Player) {
            Player player = (Player)entityDamageEvent.getEntity();
            new Cooldown(player.getUniqueId(), "LAST_DAMAGE_AUTO_ENERGY", 10L, TimeUnit.SECONDS);
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
            Energy energy = skilledPlayer.getSkill().getEnergy();
            if (energy != null && energy.hasChargingMethod(Energy.ChargingMethod.REDUCE_ON_DAMAGE)) {
                skilledPlayer.chargeEnergy(-5.0);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onHitEnergyCharge(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Energy energy;
        Player player;
        SkilledPlayer skilledPlayer;
        if (entityDamageByEntityEvent.getDamager() instanceof Player && (skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)(player = (Player)entityDamageByEntityEvent.getDamager()))).hasSkill() && (energy = skilledPlayer.getSkill().getEnergy()).hasChargingMethod(Energy.ChargingMethod.HIT)) {
            if (energy.getElements() == null || energy.getElements().isEmpty()) {
                skilledPlayer.chargeEnergy();
                return;
            }
            for (String string : energy.getElements()) {
                if (!entityDamageByEntityEvent.getEntityType().name().equals(string)) continue;
                skilledPlayer.chargeEnergy();
                break;
            }
        }
        if (entityDamageByEntityEvent.getEntity() instanceof Player && (skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)(player = (Player)entityDamageByEntityEvent.getEntity()))).hasSkill() && (energy = skilledPlayer.getSkill().getEnergy()).hasChargingMethod(Energy.ChargingMethod.PAIN)) {
            if (energy.getElements() == null || energy.getElements().isEmpty()) {
                skilledPlayer.chargeEnergy();
                return;
            }
            for (String string : energy.getElements()) {
                if (!entityDamageByEntityEvent.getEntityType().name().equals(string)) continue;
                skilledPlayer.chargeEnergy();
                break;
            }
        }
    }

    @EventHandler
    public void onHitEnergyCharge(EntityDeathEvent entityDeathEvent) {
        Player player = DamageManager.getFinalHitMob(entityDeathEvent.getEntity());
        if (player == null) {
            return;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (!skilledPlayer.hasSkill()) {
            return;
        }
        Energy energy = skilledPlayer.getSkill().getEnergy();
        if (energy.hasChargingMethod(Energy.ChargingMethod.KILL)) {
            if (energy.getElements() == null || energy.getElements().isEmpty()) {
                skilledPlayer.chargeEnergy();
                return;
            }
            for (String string : energy.getElements()) {
                if (!entityDeathEvent.getEntityType().name().equals(string)) continue;
                skilledPlayer.chargeEnergy();
                break;
            }
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent playerRespawnEvent) {
        if (SkillsConfig.isInDisabledWorld(playerRespawnEvent.getPlayer().getLocation())) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> HealthAndEnergyManager.updateStats(playerRespawnEvent.getPlayer()), 1L);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        String string;
        Player player = playerJoinEvent.getPlayer();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        skilledPlayer.setScaledHealth();
        XPAndEnchantmentManager.EXPS.put(player.getUniqueId(), player.getTotalExperience());
        if (!player.hasPlayedBefore()) {
            string = SkillsConfig.DEFAULT_SKILL.getString();
            if (!string.equalsIgnoreCase("none")) {
                Skill skill = SkillManager.getSkill(string);
                if (skill == null) {
                    MessageHandler.sendConsolePluginMessage("&4Unknown default skill option&8: &e" + string);
                } else if (skilledPlayer.setActiveSkill(skill).isCancelled()) {
                    throw new IllegalStateException("A plugin prevented setting default skill " + string + " for player " + player.getName());
                }
            }
            if (SkillsConfig.AUTO_SELECT_ON_JOIN.getBoolean()) {
                Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> CommandSelect.openMenu(player, skilledPlayer), 20L);
            }
        }
        if (SkillsConfig.isInDisabledWorld(playerJoinEvent.getPlayer().getWorld())) {
            return;
        }
        if (player.hasPermission("skills.bossbar") && SkillsConfig.BOSSBAR_LEVELS_ENABLED.getBoolean()) {
            string = StringUtils.parseBossBarFromConfig(SkillsConfig.BOSSBAR_LEVELS_FREQUENCY.getInt() < 0 ? null : player, SkillsConfig.BOSSBAR_LEVELS.getSection());
            LEVEL_BOSSBARS.put(player.getEntityId(), (BossBar)string);
        }
        HealthAndEnergyManager.updateStats(player);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (SkillsConfig.BOSSBAR_LEVELS_ENABLED.getBoolean()) {
            Integer n;
            BossBar bossBar = LEVEL_BOSSBARS.remove(player.getEntityId());
            if (bossBar != null) {
                bossBar.removeAll();
            }
            if ((n = XPAndEnchantmentManager.EXPS.remove(player.getUniqueId())) != null) {
                player.setTotalExperience(n.intValue());
            }
        }
        CustomHudChangeEvent.ANIMATIONS.remove(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldChange(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Player player = playerChangedWorldEvent.getPlayer();
        if (SkillsConfig.isInDisabledWorld(player.getLocation())) {
            BossBar bossBar = LEVEL_BOSSBARS.get(player.getEntityId());
            if (bossBar != null) {
                bossBar.removeAll();
            }
            VersionSupport.setMaxHealth((LivingEntity)player, 20.0);
        } else if (SkillsConfig.isInDisabledWorld(playerChangedWorldEvent.getFrom())) {
            if (SkillsConfig.BOSSBAR_LEVELS_ENABLED.getBoolean() && player.hasPermission("skills.bossbar")) {
                BossBar bossBar = StringUtils.parseBossBarFromConfig(player, SkillsConfig.BOSSBAR_LEVELS.getSection());
                LEVEL_BOSSBARS.put(player.getEntityId(), bossBar);
            }
            HealthAndEnergyManager.updateStats(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onExpSkillGain(SkillXPGainEvent skillXPGainEvent) {
        if (!SkillsConfig.BOSSBAR_LEVELS_ENABLED.getBoolean() && !SkillsConfig.VANILLA_EXP_BAR_ENABLED.getBoolean()) {
            return;
        }
        HealthAndEnergyManager.updateStats(skillXPGainEvent.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void hologramFire(EntityCombustEvent entityCombustEvent) {
        if (!(entityCombustEvent.getEntity() instanceof Player)) {
            return;
        }
        if (((Player)entityCombustEvent.getEntity()).getGameMode() != GameMode.CREATIVE) {
            return;
        }
        if (!SkillsConfig.DISABLE_CREATIVE_FIRE.getBoolean()) {
            return;
        }
        entityCombustEvent.setCancelled(true);
    }
}

