/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.skills.abilities.swordsman.SwordsmanPassive;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.CacheHandler;
import org.skills.utils.caffeine.cache.Cache;

public final class DamageManager
implements Listener {
    public static final String LAST_DAMAGE = "SKILLS_ATTACK";
    private static final Cache<Integer, Map<UUID, Double>> DAMAGES = CacheHandler.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private static final Cache<UUID, EntityDamageByEntityEvent> LAST_PLAYER_DAMAGES = CacheHandler.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private static final Cache<UUID, EntityDamageByEntityEvent> LAST_ENTITY_DAMAGES = CacheHandler.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private static final Cache<UUID, EntityDamageByEntityEvent> LAST_HIT_ENTITY = CacheHandler.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private static final Map<UUID, Integer> DAMAGE_TICKS = new HashMap<UUID, Integer>();

    public static void storeDamageTicks(LivingEntity livingEntity) {
        DAMAGE_TICKS.put(livingEntity.getUniqueId(), livingEntity.getNoDamageTicks());
    }

    public static void restoreDamageTicks(LivingEntity livingEntity) {
        Integer n = DAMAGE_TICKS.remove(livingEntity.getUniqueId());
        if (n != null) {
            livingEntity.setNoDamageTicks(n.intValue());
        }
    }

    public static void damage(LivingEntity livingEntity, Player player, double d) {
        if (d > 0.0) {
            livingEntity.damage(d, (Entity)player);
        }
    }

    public static EntityDamageByEntityEvent getLastHitEntity(Player player) {
        return LAST_HIT_ENTITY.getIfPresent(player.getUniqueId());
    }

    public static EntityDamageByEntityEvent getLastDamager(Player player, boolean bl) {
        return (bl ? LAST_ENTITY_DAMAGES : LAST_PLAYER_DAMAGES).getIfPresent(player.getUniqueId());
    }

    public static LivingEntity getLastSourceDamager(Player player, boolean bl) {
        EntityDamageByEntityEvent entityDamageByEntityEvent = DamageManager.getLastDamager(player, bl);
        return DamageManager.getDamager(entityDamageByEntityEvent);
    }

    protected static Player getFinalHitMob(LivingEntity livingEntity) {
        return livingEntity.getKiller();
    }

    public static Player getMostDamaged(Entity entity) {
        Map<UUID, Double> map = DAMAGES.getIfPresent(entity.getEntityId());
        if (map == null) {
            return null;
        }
        double d = 0.0;
        Player player = null;
        for (Map.Entry<UUID, Double> entry : map.entrySet()) {
            Player player2;
            if (!(entry.getValue() > d) || (player2 = Bukkit.getPlayer((UUID)entry.getKey())) == null) continue;
            d = entry.getValue();
            player = player2;
        }
        return player;
    }

    public static Player getOwningPlayer(Entity entity) {
        ProjectileSource projectileSource;
        if (entity instanceof Projectile && (projectileSource = ((Projectile)entity).getShooter()) instanceof Player) {
            Player player = (Player)projectileSource;
            if (ServiceHandler.isMyPet((Entity)player)) {
                return ServiceHandler.getPetOwner((Entity)player);
            }
            return player;
        }
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    public static LivingEntity getDamager(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        ProjectileSource projectileSource;
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Projectile && (projectileSource = ((Projectile)entity).getShooter()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)projectileSource;
            if (ServiceHandler.isMyPet((Entity)livingEntity)) {
                return ServiceHandler.getPetOwner((Entity)livingEntity);
            }
            return livingEntity;
        }
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        return (LivingEntity)entity;
    }

    public static LivingEntity getKiller(EntityDeathEvent entityDeathEvent) {
        Player player = DamageManager.getMostDamaged((Entity)entityDeathEvent.getEntity());
        if (player != null) {
            return player;
        }
        EntityDamageByEntityEvent entityDamageByEntityEvent = SwordsmanPassive.OFFHAND.remove(entityDeathEvent.getEntity().getEntityId());
        if (entityDamageByEntityEvent != null) {
            return (LivingEntity)entityDamageByEntityEvent.getDamager();
        }
        EntityDamageEvent entityDamageEvent = entityDeathEvent.getEntity().getLastDamageCause();
        if (entityDamageEvent instanceof EntityDamageByEntityEvent) {
            ProjectileSource projectileSource;
            Entity entity = ((EntityDamageByEntityEvent)entityDamageEvent).getDamager();
            if (entity instanceof Projectile && (projectileSource = ((Projectile)entity).getShooter()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)projectileSource;
                if (ServiceHandler.isMyPet((Entity)livingEntity)) {
                    return ServiceHandler.getPetOwner((Entity)livingEntity);
                }
                return livingEntity;
            }
            if (entity instanceof LivingEntity) {
                if (ServiceHandler.isMyPet(entity)) {
                    return ServiceHandler.getPetOwner(entity);
                }
                return (LivingEntity)entity;
            }
        }
        return entityDeathEvent.getEntity().getKiller();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onMostDamageHandle(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player) {
            LAST_PLAYER_DAMAGES.put(entityDamageByEntityEvent.getEntity().getUniqueId(), entityDamageByEntityEvent);
        }
        LAST_ENTITY_DAMAGES.put(entityDamageByEntityEvent.getEntity().getUniqueId(), entityDamageByEntityEvent);
        LAST_HIT_ENTITY.put(entityDamageByEntityEvent.getDamager().getUniqueId(), entityDamageByEntityEvent);
        DAMAGES.asMap().compute(entityDamageByEntityEvent.getEntity().getEntityId(), (n, hashMap) -> {
            if (hashMap == null) {
                hashMap = new HashMap<UUID, Double>();
            }
            hashMap.compute(entity.getUniqueId(), (uUID, d) -> d == null ? entityDamageByEntityEvent.getFinalDamage() : d + entityDamageByEntityEvent.getFinalDamage());
            return hashMap;
        });
    }
}

