/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers;

import com.google.common.base.Strings;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.utils.xseries.XMaterial;

public final class ArmorWeights
implements Listener {
    public static void trigger(Player player, ItemStack itemStack, boolean bl) {
        ConfigurationSection configurationSection = SkillsConfig.ARMOR_WEIGHTS_CUSTOM.getSection();
        if (configurationSection == null) {
            return;
        }
        double d = 0.0;
        if (itemStack.hasItemMeta()) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            String string = null;
            String string2 = null;
            if (itemMeta.hasDisplayName()) {
                string = MessageHandler.stripColors(itemMeta.getDisplayName(), true);
            }
            if (itemMeta.hasLore()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string3 : itemMeta.getLore()) {
                    stringBuilder.append(string3);
                }
                string2 = MessageHandler.stripColors(stringBuilder.toString(), true);
            }
            for (Object object : configurationSection.getKeys(false)) {
                Object object2;
                Object object3;
                String string3;
                string3 = configurationSection.getConfigurationSection((String)object);
                String string4 = string3.getString("type");
                if (string4 != null && (object3 = XMaterial.matchXMaterial(itemStack)) == ((Optional)(object2 = XMaterial.matchXMaterial(string4))).orElse(null)) continue;
                object3 = string3.getString("name");
                object2 = string3.getString("lore");
                if ((string == null || Strings.isNullOrEmpty((String)object3) || !string.contains((CharSequence)object3)) && (string2 == null || Strings.isNullOrEmpty((String)object2) || !string2.contains((CharSequence)object2))) continue;
                d = string3.getDouble("weight");
            }
        }
        if (d == 0.0 && (d = (configurationSection = SkillsConfig.ARMOR_WEIGHTS_WEIGHTS.getSection()).getDouble(XMaterial.matchXMaterial(itemStack).name())) == 0.0) {
            return;
        }
        float f = (float)(bl ? -d : d);
        player.setWalkSpeed(player.getWalkSpeed() + f);
    }

    public static void fullCheckup(final Player player) {
        new BukkitRunnable(){

            public void run() {
                player.setWalkSpeed(0.2f);
                if (ArmorWeights.isInvalidGameMode(player.getGameMode())) {
                    return;
                }
                if (player.hasPermission("skills.armorweight.bypass")) {
                    return;
                }
                PlayerInventory playerInventory = player.getInventory();
                if (playerInventory.getHelmet() != null) {
                    ArmorWeights.trigger(player, playerInventory.getHelmet(), true);
                }
                if (playerInventory.getChestplate() != null) {
                    ArmorWeights.trigger(player, playerInventory.getChestplate(), true);
                }
                if (playerInventory.getLeggings() != null) {
                    ArmorWeights.trigger(player, playerInventory.getLeggings(), true);
                }
                if (playerInventory.getBoots() != null) {
                    ArmorWeights.trigger(player, playerInventory.getBoots(), true);
                }
            }
        }.runTaskAsynchronously((Plugin)SkillsPro.get());
    }

    private static boolean isInvalidGameMode(GameMode gameMode) {
        return gameMode == GameMode.CREATIVE || gameMode == GameMode.SPECTATOR;
    }

    private static boolean isArmor(ItemStack itemStack) {
        switch (XMaterial.matchXMaterial(itemStack)) {
            case NETHERITE_HELMET: 
            case DIAMOND_HELMET: 
            case GOLDEN_HELMET: 
            case IRON_HELMET: 
            case LEATHER_HELMET: 
            case NETHERITE_CHESTPLATE: 
            case DIAMOND_CHESTPLATE: 
            case GOLDEN_CHESTPLATE: 
            case IRON_CHESTPLATE: 
            case LEATHER_CHESTPLATE: 
            case NETHERITE_LEGGINGS: 
            case DIAMOND_LEGGINGS: 
            case GOLDEN_LEGGINGS: 
            case IRON_LEGGINGS: 
            case LEATHER_LEGGINGS: 
            case NETHERITE_BOOTS: 
            case DIAMOND_BOOTS: 
            case GOLDEN_BOOTS: 
            case IRON_BOOTS: 
            case LEATHER_BOOTS: {
                return true;
            }
        }
        return false;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void dispenseArmorEvent(BlockDispenseArmorEvent blockDispenseArmorEvent) {
        Player player;
        if (blockDispenseArmorEvent.getTargetEntity() instanceof Player && !ArmorWeights.isInvalidGameMode((player = (Player)blockDispenseArmorEvent.getTargetEntity()).getGameMode())) {
            ArmorWeights.trigger(player, blockDispenseArmorEvent.getItem(), true);
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent inventoryCloseEvent) {
        Player player;
        if (inventoryCloseEvent.getPlayer() instanceof Player && (player = (Player)inventoryCloseEvent.getPlayer()).getOpenInventory().getTopInventory().getType() == InventoryType.CRAFTING) {
            ArmorWeights.fullCheckup(player);
        }
    }

    @EventHandler
    public void onArmorBreak(PlayerItemBreakEvent playerItemBreakEvent) {
        ItemStack itemStack = playerItemBreakEvent.getBrokenItem();
        if (ArmorWeights.isArmor(itemStack)) {
            ArmorWeights.trigger(playerItemBreakEvent.getPlayer(), itemStack, false);
        }
    }

    @EventHandler
    public void onArmorWear(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_AIR && playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (playerInteractEvent.getHand() == EquipmentSlot.OFF_HAND && player.getMainHand() == MainHand.RIGHT) {
            return;
        }
        if (ArmorWeights.isInvalidGameMode(player.getGameMode())) {
            return;
        }
        ItemStack itemStack = playerInteractEvent.getItem();
        if (itemStack == null || !ArmorWeights.isArmor(itemStack)) {
            return;
        }
        int n = player.getInventory().getHeldItemSlot();
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
            ItemStack itemStack2 = player.getInventory().getItem(n);
            if (itemStack2 == null) {
                ArmorWeights.trigger(player, itemStack, true);
            }
        }, 1L);
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent playerRespawnEvent) {
        ArmorWeights.fullCheckup(playerRespawnEvent.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onGameModeChange(PlayerGameModeChangeEvent playerGameModeChangeEvent) {
        ArmorWeights.fullCheckup(playerGameModeChangeEvent.getPlayer());
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        ArmorWeights.fullCheckup(playerJoinEvent.getPlayer());
    }
}

