/*
 * Decompiled with CFR 0.152.
 */
package org.skills.main.locale;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.StringUtils;

public class MessageHandler {
    private static final boolean SIXTEEN;
    private static final char COLOR_CODE = '&';

    public static String replaceVariables(String string, Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0 || Strings.isNullOrEmpty((String)string)) {
            return string;
        }
        Validate.isTrue((!(objectArray[0] instanceof Collection) ? 1 : 0) != 0, (String)"First element of edits is a collection (bad method use)");
        Validate.isTrue(((objectArray.length & 1) == 0 ? 1 : 0) != 0, (String)("No replacement is specified for the last variable: \"" + objectArray[objectArray.length - 1] + "\" in \"" + string + '\"' + " with edits: \"" + Arrays.toString(objectArray) + '\"'));
        for (int i = objectArray.length; i > 0; i -= 2) {
            String string2 = String.valueOf(objectArray[i - 2]);
            Object object = objectArray[i - 1];
            string = MessageHandler.replace(string, string2, object);
        }
        return string;
    }

    public static String replaceVariables(String string, List<Object> list) {
        if (list == null || list.isEmpty() || Strings.isNullOrEmpty((String)string)) {
            return string;
        }
        Validate.isTrue(((list.size() & 1) == 0 ? 1 : 0) != 0, (String)("No replacement is specified for the last variable: \"" + list.get(list.size() - 1) + "\" in \"" + string + '\"' + " with edits: \"" + Arrays.toString(list.toArray()) + '\"'));
        String string2 = null;
        for (Object object : list) {
            if (string2 == null) {
                string2 = String.valueOf(object);
                continue;
            }
            string = MessageHandler.replace(string, string2, object);
            string2 = null;
        }
        return string;
    }

    public static String replace(String string, String string2, Object object) {
        String string3;
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        int n2 = 0;
        int n3 = string.length();
        int n4 = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n3);
        if (object instanceof Supplier) {
            Supplier supplier = (Supplier)object;
            string3 = String.valueOf(supplier.get());
        } else {
            string3 = String.valueOf(object);
        }
        while (n != -1) {
            stringBuilder.append(string, n2, n).append(string3);
            n2 = n + n4;
            n = string.indexOf(string2, n2);
        }
        stringBuilder.append(string, n2, n3);
        return stringBuilder.toString();
    }

    public static void sendMessage(CommandSender commandSender, String string, boolean bl) {
        Objects.requireNonNull(commandSender, "Receiver/Sender cannot be null");
        if (Strings.isNullOrEmpty((String)string)) {
            return;
        }
        String string2 = bl ? SkillsLang.PREFIX.parse(new Object[0]) : "";
        String string3 = "";
        List<String> list = StringUtils.split(string, '\n', true);
        int n = list.size();
        for (String string4 : list) {
            string4 = string3 + MessageHandler.colorize(string4);
            commandSender.sendMessage(string2 + string4);
            if (--n == 0) continue;
            string3 = MessageHandler.getLastColors(string4);
        }
    }

    public static String getLastColors(@NotNull String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        int n2 = 14;
        for (int i = n - 1; i > -1; --i) {
            if (string.charAt(i) != '\u00a7') continue;
            char c = string.charAt(i + 1);
            if (SIXTEEN) {
                if (i >= 12 && string.charAt(i - 12) == '\u00a7' && string.charAt(i - 11) == 'x') {
                    char c2;
                    StringBuilder stringBuilder2 = new StringBuilder(n2);
                    stringBuilder2.append('\u00a7').append('x');
                    for (int j = i -= 10; j < i + 12 && string.charAt(j) == '\u00a7' && MessageHandler.isHexOrDigit(c2 = string.charAt(j + 1)); j += 2) {
                        stringBuilder2.append('\u00a7').append(c2);
                    }
                    if (stringBuilder2.length() == n2) {
                        stringBuilder.insert(0, stringBuilder2);
                        break;
                    }
                    String string2 = stringBuilder2.substring(2);
                    c2 = string2.length();
                    if (string2.isEmpty()) continue;
                    for (int j = c2 - '\u0001'; j > -1; --j) {
                        char c3;
                        if (string2.charAt(j) != '\u00a7' || !MessageHandler.appendColorBuilder(stringBuilder, c3 = string2.charAt(i + 1))) continue;
                        return stringBuilder.toString();
                    }
                    continue;
                }
                if (!MessageHandler.appendColorBuilder(stringBuilder, c)) continue;
                break;
            }
            if (MessageHandler.appendColorBuilder(stringBuilder, c)) break;
        }
        return stringBuilder.toString();
    }

    private static boolean appendColorBuilder(StringBuilder stringBuilder, char c) {
        boolean bl = MessageHandler.isFormattingCode(c);
        if (bl || MessageHandler.isHexOrDigit(c)) {
            stringBuilder.insert(0, c).insert(0, '\u00a7');
            if (bl) {
                if (c == 'R' || c == 'r') {
                    stringBuilder.setLength(0);
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static String colorize(String string) {
        if (string.isEmpty()) {
            return string;
        }
        int n = string.length() - 1;
        if (SIXTEEN) {
            StringBuilder stringBuilder = new StringBuilder(n + 50);
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (n2 >= 0) {
                    if (MessageHandler.isHexOrDigit(c)) {
                        stringBuilder.append('\u00a7').append(c);
                        if (n2++ != 6) continue;
                        n2 = -1;
                        continue;
                    }
                    n2 = -1;
                    stringBuilder.append(c);
                    continue;
                }
                if (c == '&') {
                    boolean bl;
                    char c2 = string.charAt(i + 1);
                    boolean bl2 = bl = c2 == '#';
                    if (bl || MessageHandler.isColorCode(c2)) {
                        stringBuilder.append('\u00a7');
                        if (!bl) continue;
                        stringBuilder.append('x');
                        n2 = 1;
                        ++i;
                        continue;
                    }
                    stringBuilder.append('&');
                    continue;
                }
                stringBuilder.append(c);
            }
            if (n2 == 6) {
                stringBuilder.append('\u00a7');
            }
            stringBuilder.append(string.charAt(n));
            return stringBuilder.toString();
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != '&' || !MessageHandler.isColorCode(cArray[i + 1])) continue;
            cArray[i] = 167;
            ++i;
        }
        return new String(cArray);
    }

    private static boolean isColorCode(char c) {
        return MessageHandler.isHexOrDigit(c) || MessageHandler.isFormattingCode(c);
    }

    private static boolean isFormattingCode(char c) {
        return c >= 'K' && c <= 'O' || c >= 'k' && c <= 'o' || c == 'R' || c == 'r';
    }

    private static boolean isHexOrDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static String stripColors(String string, boolean bl) {
        int n = string.length();
        if (SIXTEEN) {
            StringBuilder stringBuilder = new StringBuilder(n);
            int n2 = -1;
            for (int i = 0; i < n - 1; ++i) {
                char c = string.charAt(i);
                if (c == '\u00a7') {
                    boolean bl2;
                    char c2 = string.charAt(i + 1);
                    if (n2 != -1) {
                        if (MessageHandler.isHexOrDigit(c2)) {
                            if (bl) {
                                stringBuilder.append(c2);
                            }
                            if (n2++ == 6) {
                                n2 = -1;
                            }
                            ++i;
                            continue;
                        }
                        n2 = -1;
                        continue;
                    }
                    boolean bl3 = bl2 = c2 == 'x';
                    if (!bl2 && !MessageHandler.isColorCode(c2)) continue;
                    if (bl) {
                        stringBuilder.append('&');
                    }
                    if (bl2) {
                        if (bl) {
                            stringBuilder.append('#');
                        }
                        n2 = 0;
                    } else if (bl) {
                        stringBuilder.append(c2);
                    }
                    ++i;
                    continue;
                }
                n2 = -1;
                stringBuilder.append(c);
            }
            stringBuilder.append(string.charAt(n - 1));
            return stringBuilder.toString();
        }
        if (bl) {
            char[] cArray = string.toCharArray();
            for (int i = 0; i < n - 1; ++i) {
                if (cArray[i] != '\u00a7' || !MessageHandler.isColorCode(cArray[i + 1])) continue;
                cArray[i] = 38;
                ++i;
            }
            return new String(cArray);
        }
        char[] cArray = new char[n];
        int n3 = 0;
        for (int i = 0; i < n - 1; ++i) {
            char c = string.charAt(i);
            if (c == '\u00a7' && MessageHandler.isColorCode(string.charAt(i + 1))) {
                ++i;
                continue;
            }
            cArray[n3++] = c;
        }
        return new String(cArray, 0, n3);
    }

    public static void sendMessage(CommandSender commandSender, String string) {
        if (commandSender instanceof Player) {
            MessageHandler.sendPlayerMessage((Player)commandSender, string);
        } else {
            MessageHandler.sendConsoleMessage(string);
        }
    }

    public static void sendPluginMessage(CommandSender commandSender, String string) {
        if (commandSender instanceof Player) {
            MessageHandler.sendPlayerPluginMessage((Player)commandSender, string);
        } else {
            MessageHandler.sendConsolePluginMessage(string);
        }
    }

    public static void sendPlayerMessage(Player player, String string) {
        MessageHandler.sendMessage((CommandSender)player, string, false);
    }

    public static void sendPlayerPluginMessage(Player player, String string) {
        MessageHandler.sendMessage((CommandSender)player, string, true);
    }

    public static void sendConsoleMessage(String string) {
        MessageHandler.sendMessage((CommandSender)Bukkit.getConsoleSender(), string, false);
    }

    public static void sendConsolePluginMessage(String string) {
        MessageHandler.sendMessage((CommandSender)Bukkit.getConsoleSender(), string, true);
    }

    public static void sendPlayersMessage(String string) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            MessageHandler.sendMessage((CommandSender)player, string, false);
        }
    }

    public static void sendPlayersPluginMessage(String string) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            MessageHandler.sendMessage((CommandSender)player, string, true);
        }
    }

    public static void debug(String string) {
        String string2 = "&8[&5DEBUG&8] &4" + string;
        MessageHandler.sendMessage((CommandSender)Bukkit.getConsoleSender(), string2, true);
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("kingdoms.debug")) continue;
            MessageHandler.sendMessage((CommandSender)player, string2, true);
        }
    }

    static {
        boolean bl;
        try {
            Class.forName("org.bukkit.entity.Zoglin");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        SIXTEEN = bl;
    }
}

