/*
 * Decompiled with CFR 0.152.
 */
package org.skills.main;

import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JOptionPane;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.skills.abilities.Ability;
import org.skills.abilities.AbilityListener;
import org.skills.abilities.devourer.DevourerGliders;
import org.skills.commands.SkillsCommandHandler;
import org.skills.commands.TabCompleteManager;
import org.skills.data.database.json.OldSkillsConverter;
import org.skills.data.managers.CosmeticCategory;
import org.skills.data.managers.DataHandlers;
import org.skills.data.managers.PlayerDataManager;
import org.skills.data.managers.backup.SkillsBackup;
import org.skills.events.SkillsEventManager;
import org.skills.gui.GUIConfig;
import org.skills.gui.InteractiveGUIManager;
import org.skills.main.FileManager;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsMasteryConfig;
import org.skills.main.locale.LanguageManager;
import org.skills.managers.ArmorWeights;
import org.skills.managers.DamageManager;
import org.skills.managers.DebugManager;
import org.skills.managers.HealthAndEnergyManager;
import org.skills.managers.LevelManager;
import org.skills.managers.MoveManager;
import org.skills.managers.SkillItemManager;
import org.skills.managers.StatManager;
import org.skills.managers.XPAndEnchantmentManager;
import org.skills.managers.blood.BloodManager;
import org.skills.managers.blood.DamageAestheticsManager;
import org.skills.managers.resurrect.LastBreath;
import org.skills.masteries.managers.MasteryManager;
import org.skills.party.PartyManager;
import org.skills.services.ServiceWorldGuard;
import org.skills.services.manager.ServiceHandler;
import org.skills.types.Energy;
import org.skills.types.SkillManager;
import org.skills.types.Stat;
import org.skills.utils.Hologram;
import org.skills.utils.Metrics;
import org.skills.utils.OfflineNBT;
import org.skills.utils.UpdateChecker;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.reflection.XReflection;

public class SkillsPro
extends JavaPlugin {
    private static SkillsPro instance;
    private LanguageManager languageManager;
    private PlayerDataManager playerDataManager;
    private PartyManager partyManager;
    private UpdateChecker updater;

    public static SkillsPro get() {
        return instance;
    }

    public static void main(String[] stringArray) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(null, "An unbelievable unexpected unhandled IndexOutOfBoundsException has occurred:\nThe level is greater than the max value, resulting in an RException.\n\nThis is a Minecraft plugin.\nPut it in the plugins folder. Don't just click on it.", "RException", 0);
    }

    public LanguageManager getLang() {
        return this.languageManager;
    }

    public void onLoad() {
        instance = this;
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            ServiceWorldGuard.init();
        }
    }

    public void onEnable() {
        System.out.println("\u001b[36m[Spigotunlocked.com] - COSMO");
        SkillsPro.loadConfig0();
        FileManager fileManager = new FileManager(this);
        fileManager.createDataFolder();
        fileManager.loadConfig();
        this.languageManager = new LanguageManager(this);
        new GUIConfig(this);
        Stat.init(this);
        Energy.init(this);
        SkillManager.init(this);
        fileManager.setupWatchService();
        ServiceHandler.init(this);
        ServiceHandler.registerPlaceHolders();
        CosmeticCategory.load(this);
        PluginCommand pluginCommand = this.getCommand("skills");
        pluginCommand.setExecutor((CommandExecutor)new SkillsCommandHandler(this));
        pluginCommand.setTabCompleter((TabCompleter)new TabCompleteManager());
        this.updater = new UpdateChecker(this, 8981);
        this.partyManager = new PartyManager(this);
        this.registerAllEvents();
        new SkillsBackup(this);
        new Hologram(this);
        this.playerDataManager = new PlayerDataManager(this);
        new OldSkillsConverter(new File(this.getDataFolder(), "players"), this);
        this.playerDataManager.setTopLevels(this);
        this.updater.checkForUpdates().thenRun(this.updater::sendUpdates);
        new Metrics((Plugin)this, 6224);
        if (SkillsConfig.ARMOR_WEIGHTS_RESET_SPEEDS_ENABLED.getBoolean()) {
            if (XReflection.supports(17)) {
                throw new IllegalStateException("Armor weight reset option is currently not supported on " + Bukkit.getVersion());
            }
            OfflineNBT.perform();
        }
    }

    public void onDisable() {
        if (this.playerDataManager == null) {
            return;
        }
        this.playerDataManager.saveAll();
        this.partyManager.saveAll();
        Hologram.onDisable();
        DevourerGliders.onDisable();
        Ability.onDisable();
    }

    public void reload() {
        this.languageManager = new LanguageManager(this);
    }

    private void registerEvent(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    private void registerAllEvents() {
        this.registerEvent(new HealthAndEnergyManager(this));
        this.registerEvent(new AbilityListener());
        this.registerEvent(new InteractiveGUIManager());
        this.registerEvent(new SkillItemManager());
        this.registerEvent(new MoveManager());
        this.registerEvent(new XPAndEnchantmentManager());
        this.registerEvent(new SkillsEventManager());
        this.registerEvent(new DebugManager());
        this.registerEvent(new StatManager());
        if (SkillsConfig.LAST_BREATH_ENABLED.getBoolean() && XMaterial.supports(13)) {
            this.registerEvent(new LastBreath());
        }
        if (SkillsConfig.SMART_DAMAGE.getBoolean()) {
            this.registerEvent(new DamageManager());
        }
        if (SkillsConfig.RED_SCREEN_ENABLED.getBoolean() || SkillsConfig.PULSE_ENABLED.getBoolean()) {
            this.registerEvent(new DamageAestheticsManager());
        }
        if (SkillsConfig.BLOOD_ENABLED.getBoolean()) {
            this.registerEvent(new BloodManager());
        }
        this.registerEvent(new LevelManager(this));
        if (SkillsMasteryConfig.MASTERIES_ENABLED.getBoolean().booleanValue()) {
            new MasteryManager();
        }
        if (SkillsConfig.ARMOR_WEIGHTS_ENABLED.getBoolean()) {
            this.registerEvent(new ArmorWeights());
        }
        this.registerEvent(new DataHandlers(this));
        this.registerEvent(this.partyManager);
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public UpdateChecker getUpdater() {
        return this.updater;
    }

    public PartyManager getPartyManager() {
        return this.partyManager;
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection uRLConnection = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=%%__USER__%%&resource_id=%%__RESOURCE__%%&nonce=%%__NONCE__%%").openConnection();
            uRLConnection.setConnectTimeout(1000);
            uRLConnection.setReadTimeout(1000);
            ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(true);
            String string = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream())).readLine();
            if ("false".equals(string)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

