/*
 * Decompiled with CFR 0.152.
 */
package org.skills.main;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.main.locale.LanguageManager;
import org.skills.main.locale.MessageHandler;
import org.skills.utils.MathUtils;
import org.skills.utils.StringUtils;

public enum SkillsConfig {
    PREFIX(false),
    LANG("en"),
    DEBUG(false),
    CHECK_UPDATES(true),
    DATABASE("JSON"),
    LOAD_ALL_DATA_ON_STARTUP(true),
    AUTOSAVE_INTERVAL("30mins"),
    ANNOUNCE_AUTOSAVES(true),
    COMMANDS_EACH_PAGE(5),
    SMART_DAMAGE("smart-damage"),
    BACKUPS_ENABLED(true, 1),
    BACKUPS_IGNORE_TODAYS_BACKUP(false, 1),
    BACKUPS_DELETE_BACKUPS_OLDER_THAN(30, 1),
    BUY_CLASS_ONCE(true),
    ACTIONBAR_ENABLED(true, 1),
    ACTIONBAR_DEFAULT(true, 1),
    ACTIONBAR_FREQUENCY(10, 1),
    ACTIONBAR_NORMAL("&8-=( %skills_status% &9\u222b %skills_energy_string%&l%skills_energy_symbol% &9\u222b &3Lvl. &e%skills_short_level% &9\u222b &3%skills_short_xp%&8/&3%skills_short_maxxp% &9\u222b &3%skills_short_soul% &9\u222b &3%skills_active_cooldown% &8)=-", 1),
    ACTIONBAR_ACTIVATED_SKILL("&4-=<=[ %skills_status% &c\ufe34 %skills_energy_string%&l%skills_energy_symbol% &c\ufe34 &6\u2112\u03bd\u2113. &e%skills_short_level% &c\ufe34 &6%skills_short_xp%&8/&6%skills_short_maxxp% &c\ufe34 &6%skills_short_soul% &4]=>=-", 1),
    ACTIONBAR_STATUS_OK("&2\u2764", 1, 2),
    ACTIONBAR_STATUS_POISONED("&5\u2623", 1, 2),
    ACTIONBAR_STATUS_LOWHEALTH("&4\u2665", 1, 2),
    ACTIONBAR_STATUS_ACTIVATED("&0&o\u2766", 1, 2),
    ACTIONBAR_COOLDOWN_READY("&200 \u231b", 1, 2),
    ACTIONBAR_COOLDOWN_NOT_READY("&c%time% \u231b", 1, 2),
    ACTIONBAR_ENERGY_CHARGED("%skills_energy_color%\u2758", 1, 2),
    ACTIONBAR_ENERGY_EMPTY("&8\u2758", 1, 2),
    ACTIONBAR_ENERGY_FULL("%skills_energy_color%&o\u2758", 1, 2),
    ACTIONBAR_ENERGY_FULL_SECOND("&0&o\u2503", 1, 2),
    LOSS_MIN_LEVEL(0),
    PRECISIONS_HEALTHS(2, 1),
    PRECISIONS_ENERGY(1, 1),
    DEFAULT_HEALTH_SCALING(40),
    LEVEL_CELEBRATION(true),
    SKILL_CHANGE_RESET_LEVEL(false, 3),
    SKILL_CHANGE_RESET_SOULS(false, 3),
    SKILL_CHANGE_RESET_STATS(false, 3),
    SKILL_CHANGE_RESET_ABILITIES(false, 3),
    SKILL_CHANGE_RESET_MASTERIES(false, 3),
    BOSSBAR_LEVELS_ENABLED(true, 1, 2),
    BOSSBAR_LEVELS_FREQUENCY(0, 1, 2),
    BOSSBAR_LEVELS(null, 1),
    BOSSBAR_EVENTS_ENABLED(true, 1, 2),
    BOSSBAR_EVENTS(null, 1),
    BOSSBAR_BONUSES_ENABLED(true, 1, 2),
    BOSSBAR_BONUSES(null, 1),
    AUTO_SELECT_ON_JOIN(false),
    DEFAULT_SKILL("none"),
    VANILLA_EXP_BAR_ENABLED(true, 3),
    VANILLA_EXP_BAR_SHOWN_NUMBER(true, 3),
    VANILLA_EXP_BAR_REAL_SYNC(false, 3),
    ENCHANTMENT_TABLES_ADDITIONAL_COSTS_SOULS(0, 2, 4),
    ENCHANTMENT_TABLES_ADDITIONAL_COSTS_SKILL_LEVEL(0, 2, 4),
    ENCHANTMENT_TABLES_ADDITIONAL_COSTS_SKILL_XP(0, 2, 4),
    TIME_FORMAT("hha:mm:ss"),
    DISCORDSRV_PARTY_CHANNEL("$main"),
    ECONOMY_DEPOSIT_ENABLED(true, 1, 2),
    ECONOMY_DEPOSIT_SOUL_WORTH(50.0, 1, 2),
    ECONOMY_WITHDRAW_ENABLED(true, 1, 2),
    ECONOMY_WITHDRAW_SOUL_WORTH(true, 1, 2),
    DISABLED_WORLDS_PLUGIN(new String[0], 2),
    DISABLED_WORLDS_SOUL_LOSS(new String[0], 2),
    DISABLED_WORLDS_SOUL_GAIN(new String[0], 2),
    DISABLE_ABILITIES_IN_REGIONS(true),
    DISABLED_WORLDS_XP_GAIN(new String[0], 2),
    DISABLED_WORLDS_XP_LOSS(new String[0], 2),
    SKILL_ACTIVATION_TIME(500),
    XP(new String[0]),
    DEFAULT_XP(-1),
    DEFAULT_SOULS(1),
    SOULS(new String[0]),
    DISABLE_CREATIVE_FIRE(true),
    STARTER_ENABLED(false, 1),
    STARTER_LEVEL(0, 1),
    STARTER_ABILITIES_LEVEL(0, 1),
    STARTER_MASTERIES(0, 1),
    STARTER_SOULS(0, 1),
    STARTER_STATS(null, 1),
    ARMOR_WEIGHTS_ENABLED(false, 2),
    ARMOR_WEIGHTS_RESET_SPEEDS_ENABLED(false, 2, 4),
    ARMOR_WEIGHTS_RESET_SPEEDS_AMOUNT(Float.valueOf(0.2f), 2, 4),
    ARMOR_WEIGHTS_WEIGHTS(new String[0], 2),
    ARMOR_WEIGHTS_CUSTOM(new String[0], 2),
    SPAWNERS_XP("%xp% / 3", 1),
    SKILLS_SHARED_DATA_SOULS(true, 3),
    SKILLS_SHARED_DATA_STATS(false, 3),
    SKILLS_SHARED_DATA_LEVELS(false, 3),
    CLOSE_GUI_ON_DAMAGE(false),
    SPAWNERS_SOULS(0, 1),
    PREVENT_ACTIVATION_ITEMS(new String[0], 2),
    PREVENT_ACTIVATION_BLOCKS(new String[0], 2),
    DEFAULT_MAX_LEVEL(100),
    LEVELS(null),
    READY_PARTICLE_PARTICLE("SPELL_WITCH", 2),
    READY_PARTICLE_COUNT("lvl * 10", 2),
    READY_PARTICLE_OFFSET(0.1, 2),
    BLOOD_ENABLED(true, 1),
    BLOOD_DEFAULT("STEP_SOUND, REDSTONE_BLOCK, 10", 1),
    BLOOD_SHIELD("STEP_SOUND, OAK_WOOD, 10", 1),
    BLOOD_CUSTOM_MOBS(null, 1),
    BLOOD_DISABLED_MOBS(new String[0], 1),
    RED_SCREEN_ENABLED(true, 2),
    RED_SCREEN_DURATION(10, 2),
    RED_SCREEN_HEALTH(50, 2),
    LAST_BREATH_ENABLED(false, 2),
    LAST_BREATH_INVULNERABILITY(15, 2),
    LAST_BREATH_BOSSBAR(null, 2),
    LAST_BREATH_COOLDOWN(60, 2),
    LAST_BREATH_INTENSITY_RESISTANCE(10, 2),
    LAST_BREATH_SOUNDS_MUSIC("MUSIC_DISC_13, 10", 2, 3),
    LAST_BREATH_SOUNDS_START("BLOCK_CONDUIT_DEACTIVATE, 10, 0", 2, 3),
    LAST_BREATH_SOUNDS_BLEED_OUT("none", 2, 3),
    LAST_BREATH_SOUNDS_REVIVE("UI_TOAST_CHALLENGE_COMPLETE, 0.5, 2", 2, 3),
    LAST_BREATH_MOBS_IGNORE(false, 2),
    LAST_BREATH_SPEED(0.1, 2),
    LAST_BREATH_BLEED_OUT(60, 2),
    LAST_BREATH_DAMAGE(0.001, 2),
    LAST_BREATH_REVIVE_TIME(10, 2, 3),
    LAST_BREATH_REVIVE_DISTANCE(10, 2, 3),
    PULSE_ENABLED(true, 1),
    PULSE_DURATION(2000, 1),
    PULSE_HEALTH(20, 1),
    PULSE_LUB("BLOCK_NOTE_BLOCK_BASEDRUM", 1),
    PULSE_DUB("BLOCK_NOTE_BLOCK_BASEDRUM", 1),
    SOULS_LOSS_UPON_DEATH(5),
    XP_LOSS_UPON_DEATH(5),
    LOSE_SAME_SOULS_AS_KILLER_SOULS_GAIN(true),
    LOSE_SAME_XP_AS_KILLER_XP_GAIN(true),
    SKILL_CHANGE_COOLDOWN(60),
    COMMANDS_TO_PERFORM_SELECT(new String[0], 1),
    COMMANDS_TO_PERFORM_CHANGE(new String[0], 1),
    DISABLED_COMMANDS(new String[0]),
    ACTIVATION_KEY("R", 1),
    DEFAULT_GUI_CLICK_SOUND(null),
    MASTERY_LOGGING_MATERIALS(new String[]{"OAK_LOG:OAK_LOG, 3, 100", "ACACIA_LOG:ACACIA_LOG, 2, 100", "BIRCH_LOG:BIRCH_LOG, 2, 100", "DARK_OAK_LOG:DARK_OAK_LOG, 4, 70", "JUNGLE_LOG:JUNGLE_LOG, 4, 70", "SPRUCE_LOG:SPRUCE_LOG, 2, 100"}),
    MASTERIES_ENABLED(true, 1),
    STATS_ALLOW_RESET(true, 1),
    STATS_RESET_COST(0, 1),
    FRIENDS_FRIENDLY_FIRE(false, 1),
    FRIENDS_MAX_FRIENDS(50, 1),
    FRIENDS_TELEPORT_ENABLED(true, 1, 2),
    FRIENDS_TELEPORT_TIMER(5, 1, 2),
    FRIENDS_TELEPORT_SHOULD_NOT_MOVE(true, 1, 2),
    FRIENDS_TELEPORT_DELAY_BEFORE_MOVE_CHECK(3, 1, 2),
    FRIENDS_TELEPORT_REQUEST_TIME(60, 1, 2),
    PARTY_FRIENDLY_FIRE(false, 1),
    PARTY_DISTRIBUTE(true, 1),
    PARTY_MAX_MEMBERS(50, 1),
    PARTY_SOULS_PER_MEMBER("%skills_party% / 5 + souls", 1),
    PARTY_XP_PER_MEMBER("%skills_party% / 2 + exp", 1),
    PARTY_MEMBERS_MAX_DISTANCE(0, 1),
    PARTY_CHAT_FORMAT("&7[&5%skills_party_name%&7]&8|7[&5%skills_party_name%&7]&8|&7[&5%skills_party_rank%&7] %displayname% &8\u00bb &d", 1),
    PARTY_SPY_FORMAT("&7[&5SPY&7] &7[&5%skills_party_name%&7]&8|7[&5%skills_party_name%&7]&8|&7[&5%skills_party_rank%&7] %displayname% &8\u00bb &d", 1),
    KILL_MESSAGE(false),
    HOLOGRAM_ENABLED(true, 1),
    HOLOGRAM_EFFECT("LEVITATION, 1, 2", 1),
    HOLOGRAM_STAY(40, 1),
    HOLOGRAM_OFFSET(null, 1),
    HOLOGRAM_STATIC(false, 1),
    HOLOGRAM_LINES(new String[]{"&3Souls&8: &2+%souls%", "&3XP&8: &2+%xp%"}, 1),
    HOLOGRAM_DAMAGE_INDICATOR(new String[]{"&4%damage%"}, 1),
    HOLOGRAM_DAMAGE_INDICATOR_PRECISION(2, 1),
    HOLOGRAM_DISABLED_MOBS(new String[0], 1),
    MYTHICMOBS_WORLDS_WITH_LEVEL_MARGIN(new String[0], 1),
    MYTHICMOBS_XP_CONDITIONS(new String[0], 1),
    MYTHICMOBS_SOUL_CONDITIONS(new String[0], 1);

    private static final SkillsPro plugin;
    private final String option;
    private final Object defaultValue;

    private SkillsConfig(Object object) {
        this.option = this.name().toLowerCase().replace('_', '-');
        this.defaultValue = object;
    }

    private SkillsConfig(Object object, int ... nArray) {
        this.option = StringUtils.getGroupedOption(this.name(), nArray);
        this.defaultValue = object;
    }

    public static boolean isInDisabledWorld(Location location) {
        return DISABLED_WORLDS_PLUGIN.getStringList().contains(location.getWorld().getName());
    }

    public static boolean isInDisabledWorld(World world) {
        return DISABLED_WORLDS_PLUGIN.getStringList().contains(world.getName());
    }

    public static int getClosestLevelSection(ConfigurationSection configurationSection, int n) {
        Validate.isTrue((n >= 0 ? 1 : 0) != 0, (String)"No level properties for levels lower than 1");
        Objects.requireNonNull(configurationSection, "Cannot get closest level section from null master section");
        ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(String.valueOf(n));
        int n2 = -1;
        if (configurationSection2 == null) {
            Set set = configurationSection.getKeys(false);
            int n3 = 0;
            for (String string : set) {
                int n4 = NumberUtils.toInt((String)string, (int)n3);
                if (n4 > n && n3 <= n) {
                    n2 = n3;
                    break;
                }
                n3 = n4;
            }
            if (n2 == -1) {
                n2 = n3;
            }
        } else {
            return n;
        }
        return n2;
    }

    public boolean isSet() {
        return plugin.getConfig().isSet(this.option);
    }

    public String getOption() {
        return this.option;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getString() {
        return plugin.getConfig().getString(this.option);
    }

    public String parse(OfflinePlayer offlinePlayer, Object ... objectArray) {
        return LanguageManager.buildMessage(this.getString(), offlinePlayer, objectArray);
    }

    public List<String> getStringList() {
        return plugin.getConfig().getStringList(this.option);
    }

    public Set<String> getSectionSet() {
        return plugin.getConfig().getConfigurationSection(this.option).getKeys(false);
    }

    public ConfigurationSection getSection() {
        return plugin.getConfig().getConfigurationSection(this.option);
    }

    public double getDouble() {
        return plugin.getConfig().getDouble(this.option);
    }

    public double fromEquation(OfflinePlayer offlinePlayer, Object ... objectArray) {
        return MathUtils.evaluateEquation(MessageHandler.replaceVariables(this.parse(offlinePlayer, objectArray), new Object[0]));
    }

    public long getTimeMillis() {
        return this.getTimeMillis(TimeUnit.MILLISECONDS);
    }

    public long getTimeMillis(TimeUnit timeUnit) {
        Long l = MathUtils.calcMillis(this.getString(), timeUnit);
        return l == null ? 0L : l;
    }

    public double eval(SkilledPlayer skilledPlayer, Ability ability) {
        String string = this.getString();
        if (string == null) {
            return 0.0;
        }
        return MathUtils.evaluateEquation(ability.getTranslatedScaling(skilledPlayer, string, new Object[0]));
    }

    public long getLong() {
        return plugin.getConfig().getLong(this.option);
    }

    public boolean getBoolean() {
        return plugin.getConfig().getBoolean(this.option);
    }

    public int getInt() {
        return plugin.getConfig().getInt(this.option);
    }

    static {
        plugin = SkillsPro.get();
    }
}

