/*
 * Decompiled with CFR 0.152.
 */
package org.skills.main;

import java.util.Arrays;
import java.util.function.Supplier;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;

public class SLogger {
    private final StringBuilder builder;
    private boolean shown;

    public SLogger() {
        if (SkillsConfig.DEBUG.getBoolean()) {
            this.builder = new StringBuilder(100);
            this.builder.append("---------------- ").append(Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).findFirst().get()).append(" ----------------").append('\n');
        } else {
            this.builder = null;
        }
    }

    public static void info(String string) {
        SkillsPro.get().getLogger().info(string);
    }

    public static void debug(Supplier<String> supplier) {
        if (SkillsConfig.DEBUG.getBoolean()) {
            String string = supplier.get();
            MessageHandler.sendConsolePluginMessage("&7[&5DEBUG&7] &6" + string);
            MessageHandler.sendPlayersPluginMessage("&7[&5DEBUG&7] &6" + string);
        }
    }

    public SLogger add(Supplier<String> supplier) {
        if (this.builder != null) {
            this.builder.append(supplier.get()).append('\n');
        }
        return this;
    }

    public SLogger add(String string) {
        if (this.builder != null) {
            this.builder.append(string).append('\n');
        }
        return this;
    }

    public void show() {
        if (this.shown) {
            return;
        }
        if (this.builder != null) {
            this.shown = true;
            this.builder.append("============================================");
            SLogger.debug(this.builder.toString());
        }
    }

    protected void finalize() {
        super.finalize();
        this.show();
    }

    public static void debug(String string) {
        SLogger.debug(() -> string);
    }

    public static void warn(String string) {
        SkillsPro.get().getLogger().warning(string);
    }

    public static void error(String string) {
        SkillsPro.get().getLogger().severe(string);
    }
}

