/*
 * Decompiled with CFR 0.152.
 */
package org.skills.gui;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.skills.data.AdapterYamlConfig;
import org.skills.main.SLogger;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;

public class GUIConfig {
    private static final Map<String, AdapterYamlConfig> GUIS = new HashMap<String, AdapterYamlConfig>();
    private final SkillsPro plugin;
    private final String lang;

    public GUIConfig(SkillsPro skillsPro) {
        this.plugin = skillsPro;
        String string = SkillsConfig.LANG.getString();
        this.lang = SkillsPro.get().getResource("guis/" + string) == null && !new File(SkillsPro.get().getDataFolder(), "guis/" + string).exists() ? "en" : string;
        GUIS.clear();
        this.registerGUI("selector");
        this.registerGUI("friends");
        this.registerGUI("party");
        this.registerGUI("parties");
        this.registerGUI("shop");
        this.registerGUI("stats");
        this.registerGUI("stats-reset-confirmation");
        this.registerGUI("abilities");
        this.registerGUI("party-member");
        this.registerGUI("masteries");
    }

    public static AdapterYamlConfig getAdapter(String string) {
        return GUIS.get(string);
    }

    public static FileConfiguration getGUI(String string) {
        AdapterYamlConfig adapterYamlConfig = GUIConfig.getAdapter(string);
        return adapterYamlConfig == null ? null : adapterYamlConfig.getConfig();
    }

    public static void registerGUI(Plugin plugin, String string) {
        String string2 = "guis/" + SkillsConfig.LANG.getString() + '/' + string + ".yml";
        if (SkillsPro.class.getResource('/' + string2) == null) {
            string2 = "guis/en/" + string + ".yml";
        }
        AdapterYamlConfig adapterYamlConfig = new AdapterYamlConfig(new File(plugin.getDataFolder(), string2), string2).register();
        GUIS.put(string, adapterYamlConfig);
    }

    public void registerGUI(String string) {
        SLogger.debug("Loading GUI&8: &9" + string);
        String string2 = "guis/" + this.lang + '/' + string + ".yml";
        if (SkillsPro.class.getResource('/' + string2) == null) {
            string2 = "guis/en/" + string + ".yml";
        }
        AdapterYamlConfig adapterYamlConfig = new AdapterYamlConfig(new File(this.plugin.getDataFolder(), string2), string2).register();
        GUIS.put(string, adapterYamlConfig);
    }

    public void reload() {
        GUIS.forEach((string, adapterYamlConfig) -> adapterYamlConfig.reloadConfig());
    }
}

