/*
 * Decompiled with CFR 0.152.
 */
package org.skills.events;

import java.time.Duration;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.skills.events.SkillsBonus;
import org.skills.events.SkillsEventType;
import org.skills.main.SkillsConfig;

public final class SkillsPersonalBonus
extends SkillsBonus {
    private transient UUID id;

    public SkillsPersonalBonus(UUID uUID, SkillsEventType skillsEventType, String string, Duration duration, long l) {
        super(skillsEventType, string, duration, l);
        this.id = Objects.requireNonNull(uUID);
    }

    @Override
    public SkillsBonus clone() {
        return new SkillsPersonalBonus(this.id, this.type, this.multiplier, this.duration, this.start);
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.id);
    }

    @Override
    public boolean appliesTo(Player player) {
        return player.getUniqueId().equals(this.id) && super.appliesTo(player);
    }

    @Override
    public void start() {
        super.start();
        if (this.bossBar != null) {
            return;
        }
        ConfigurationSection configurationSection = SkillsConfig.BOSSBAR_BONUSES.getSection();
        if (configurationSection.getBoolean("enabled")) {
            this.bossBar = new SkillsBonus.BossBarHandler(configurationSection);
            Player player = this.getPlayer();
            if (player != null) {
                this.bossBar.addPlayer(player);
            }
        }
    }

    @ApiStatus.Internal
    public void setPlayerId(UUID uUID) {
        Objects.requireNonNull(uUID);
        if (this.id != null) {
            throw new IllegalArgumentException("Bonus ID already set");
        }
        this.id = uUID;
    }

    public UUID getPlayerId() {
        return this.id;
    }
}

