/*
 * Decompiled with CFR 0.152.
 */
package org.skills.events;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.skills.data.managers.SkilledPlayer;
import org.skills.events.SkillsBonus;
import org.skills.events.SkillsEventType;
import org.skills.events.SkillsGlobalBonus;
import org.skills.events.SkillsPersonalBonus;

public class SkillsEventManager
implements Listener {
    protected static final EnumMap<SkillsEventType, SkillsGlobalBonus> EVENTS = new EnumMap(SkillsEventType.class);

    public static EnumMap<SkillsEventType, SkillsGlobalBonus> getEvents() {
        return EVENTS;
    }

    public static SkillsGlobalBonus getEvent(SkillsEventType skillsEventType) {
        SkillsGlobalBonus skillsGlobalBonus = EVENTS.get((Object)skillsEventType);
        if (skillsGlobalBonus != null && skillsGlobalBonus.hasExpired()) {
            skillsGlobalBonus.stop();
            EVENTS.remove((Object)skillsEventType);
            return null;
        }
        return skillsGlobalBonus;
    }

    public static boolean isEventRunning(SkillsEventType skillsEventType) {
        SkillsGlobalBonus skillsGlobalBonus = SkillsEventManager.getEvent(skillsEventType);
        if (skillsGlobalBonus == null) {
            return false;
        }
        return skillsGlobalBonus.isActive();
    }

    private static void handleBonuses(Player player, boolean bl) {
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        List<SkillsPersonalBonus> list = new ArrayList<SkillsPersonalBonus>(skilledPlayer.getBonuses());
        list.forEach(SkillsBonus::start);
        list.addAll(EVENTS.values());
        list = list.stream().filter(SkillsBonus::isActive).filter(skillsBonus -> skillsBonus.appliesTo(player)).filter(skillsBonus -> skillsBonus.bossBar != null).collect(Collectors.toList());
        for (SkillsBonus skillsBonus2 : list) {
            boolean bl2;
            boolean bl3 = bl2 = bl || !skillsBonus2.appliesTo(player);
            if (bl2 && skillsBonus2.bossBar != null) {
                skillsBonus2.bossBar.removePlayer(player);
                continue;
            }
            skillsBonus2.bossBar.addPlayer(player);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        SkillsEventManager.handleBonuses(player, false);
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        SkillsEventManager.handleBonuses(player, true);
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Player player = playerChangedWorldEvent.getPlayer();
        SkillsEventManager.handleBonuses(player, false);
    }
}

