/*
 * Decompiled with CFR 0.152.
 */
package org.skills.events;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.skills.data.managers.SkilledPlayer;
import org.skills.events.SkillsEventManager;
import org.skills.events.SkillsEventType;
import org.skills.events.SkillsPersonalBonus;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.LanguageManager;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.MathUtils;
import org.skills.utils.NoEpochDate;
import org.skills.utils.StringUtils;

public abstract class SkillsBonus
implements Cloneable {
    protected final Duration duration;
    protected final long start;
    protected final SkillsEventType type;
    protected final String multiplier;
    protected transient boolean stopped;
    protected transient BossBarHandler bossBar;

    public SkillsBonus(SkillsEventType skillsEventType, String string, Duration duration, long l) {
        this.type = Objects.requireNonNull(skillsEventType, "Event type cannot be null");
        this.multiplier = Objects.requireNonNull(string, "Event multiplier cannot be null");
        this.duration = Objects.requireNonNull(duration);
        this.start = l;
        if (l <= 0L) {
            throw new IllegalArgumentException("Start time not invalid: " + this);
        }
    }

    public void stop() {
        this.stopped = true;
        if (this.bossBar != null) {
            this.bossBar.removeAll();
        }
    }

    public abstract SkillsBonus clone();

    public void start() {
        this.stopped = false;
    }

    public boolean appliesTo(Player player) {
        ArrayList<String> arrayList = new ArrayList<String>(SkillsConfig.DISABLED_WORLDS_PLUGIN.getStringList());
        if (this.type == SkillsEventType.XP) {
            arrayList.addAll(SkillsConfig.DISABLED_WORLDS_XP_GAIN.getStringList());
        } else if (this.type == SkillsEventType.SOUL) {
            arrayList.addAll(SkillsConfig.DISABLED_WORLDS_SOUL_GAIN.getStringList());
        }
        return !arrayList.contains(player.getWorld().getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.type.name() + ", " + this.multiplier + ", " + this.duration + ", " + this.start + ')';
    }

    public final SkillsEventType getType() {
        return this.type;
    }

    public String getMultiplier() {
        return this.multiplier;
    }

    public static double getMultiplierFor(Player player, SkillsEventType skillsEventType) {
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        ArrayList<SkillsPersonalBonus> arrayList = new ArrayList<SkillsPersonalBonus>(skilledPlayer.getBonus(skillsEventType));
        if (SkillsEventManager.isEventRunning(skillsEventType)) {
            arrayList.add((SkillsPersonalBonus)((Object)SkillsEventManager.getEvent(skillsEventType)));
        }
        return arrayList.stream().filter(SkillsBonus::isActive).filter(skillsBonus -> skillsBonus.appliesTo(player)).map(skillsBonus -> skillsBonus.getMultiplierFor((OfflinePlayer)player)).reduce(1.0, (d, d2) -> d * d2);
    }

    public final double getMultiplierFor(OfflinePlayer offlinePlayer) {
        String string = this.multiplier;
        if (offlinePlayer != null) {
            string = ServiceHandler.translatePlaceholders(offlinePlayer, this.multiplier);
        }
        return MathUtils.evaluateEquation(string);
    }

    public final String getDisplayDuration() {
        return new NoEpochDate(this.getTimeLeft().toMillis()).format(SkillsConfig.TIME_FORMAT.getString());
    }

    public final long getStart() {
        return this.start;
    }

    public final Duration getTimeLeft() {
        Duration duration = this.duration.minus(this.getTimePassed());
        return duration.isNegative() ? Duration.ZERO : duration;
    }

    public final Duration getTimePassed() {
        return Duration.ofMillis(System.currentTimeMillis() - this.start);
    }

    public final boolean isActive() {
        return !this.stopped && !this.hasExpired();
    }

    public final boolean hasExpired() {
        return this.getTimeLeft().isZero();
    }

    public final Duration getDuration() {
        return this.duration;
    }

    public final class BossBarHandler
    implements Runnable {
        private BukkitTask bukkitTask;
        private final BossBar bossBar;
        private final String title;

        protected BossBarHandler(ConfigurationSection configurationSection) {
            this.title = configurationSection.getString("title");
            this.bossBar = StringUtils.parseBossBarFromConfig(null, configurationSection);
        }

        private void start() {
            this.bukkitTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)SkillsPro.get(), (Runnable)this, 0L, 1L);
        }

        private boolean isTaskRunning() {
            return this.bukkitTask != null;
        }

        public void addPlayer(Player player) {
            if (!this.isTaskRunning()) {
                this.start();
            }
            this.bossBar.addPlayer(player);
        }

        public void removePlayer(Player player) {
            this.bossBar.removePlayer(player);
            if (this.isTaskRunning() && this.bossBar.getPlayers().isEmpty()) {
                this.cancel();
            }
        }

        private void cancel() {
            this.bukkitTask.cancel();
            this.bukkitTask = null;
        }

        protected void removeAll() {
            this.bossBar.removeAll();
        }

        @Override
        public void run() {
            if (!SkillsBonus.this.isActive()) {
                this.cancel();
                if (!SkillsBonus.this.stopped) {
                    SkillsBonus.this.stop();
                }
                return;
            }
            float f = Math.abs((float)SkillsBonus.this.getTimeLeft().toMillis() / (float)SkillsBonus.this.duration.toMillis());
            this.bossBar.setProgress((double)f);
            this.bossBar.setTitle(LanguageManager.buildMessage(this.title, null, "%type%", SkillsBonus.this.type.toString(), "%multiplier%", String.valueOf(SkillsBonus.this.getMultiplierFor(null)), "%time%", SkillsBonus.this.getDisplayDuration()));
        }
    }
}

