/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.managers.backup;

import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.data.managers.backup.BackupManager;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class SkillsBackup
extends BackupManager {
    private static SkillsBackup instance;

    public SkillsBackup(SkillsPro skillsPro) {
        super(new File(skillsPro.getDataFolder(), "backups"), skillsPro.getDataFolder());
        instance = this;
        useMultiBackups = SkillsConfig.BACKUPS_IGNORE_TODAYS_BACKUP.getBoolean();
        this.autoBackup(skillsPro);
    }

    public static SkillsBackup getInstance() {
        return instance;
    }

    public void autoBackup(SkillsPro skillsPro) {
        new BukkitRunnable(){

            public void run() {
                SkillsBackup.this.takeBackup();
            }
        }.runTaskTimerAsynchronously((Plugin)skillsPro, 0L, 1728060L);
    }

    @Override
    public void takeBackup() {
        MessageHandler.sendConsolePluginMessage("&2Taking a backup...");
        if (!useMultiBackups && this.hasBackupToday()) {
            MessageHandler.sendConsolePluginMessage("&2You already have a backup for today!");
            return;
        }
        this.deleteOldBackups(SkillsConfig.BACKUPS_DELETE_BACKUPS_OLDER_THAN.getInt(), TimeUnit.DAYS);
        this.zipFiles().thenAccept(n -> MessageHandler.sendConsolePluginMessage("&2Backed up &6" + n + " &2files."));
    }

    @Override
    public boolean isWhitelistedDirectory(@NonNull Path path) {
        String string = path.getFileName().toString();
        return SkillsConfig.BACKUPS_ENABLED.getBoolean() && string.equals("players");
    }

    @Override
    public boolean isWhitelistedFile(@NonNull Path path) {
        String string = path.getFileName().toString();
        return StringUtils.countMatches((String)string, (String)"-") == 4 && string.replace(".json", "").length() == 36 && string.toLowerCase().endsWith(".json") || string.toLowerCase().endsWith(".yml");
    }
}

