/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.skills.abilities.Ability;
import org.skills.abilities.ActiveAbility;
import org.skills.abilities.eidolon.EidolonForm;
import org.skills.api.events.ClassChangeEvent;
import org.skills.api.events.EidolonImbalanceChangeEvent;
import org.skills.api.events.SkillActiveStateChangeEvent;
import org.skills.api.events.SkillEnergyChangeEvent;
import org.skills.api.events.SkillImproveEvent;
import org.skills.api.events.SkillLevelUpEvent;
import org.skills.api.events.SkillToggleAbilityEvent;
import org.skills.data.database.DataContainer;
import org.skills.data.managers.Cosmetic;
import org.skills.data.managers.CosmeticCategory;
import org.skills.data.managers.PlayerAbilityData;
import org.skills.data.managers.PlayerSkill;
import org.skills.events.SkillsBonus;
import org.skills.events.SkillsEventType;
import org.skills.events.SkillsPersonalBonus;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.LevelManager;
import org.skills.managers.LevelUp;
import org.skills.masteries.managers.Mastery;
import org.skills.masteries.managers.MasteryManager;
import org.skills.party.PartyRank;
import org.skills.party.SkillsParty;
import org.skills.types.Skill;
import org.skills.types.SkillScaling;
import org.skills.types.Stat;
import org.skills.utils.Cooldown;
import org.skills.utils.FastUUID;
import org.skills.utils.NoEpochDate;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;
import org.skills.utils.xseries.XSound;

public class SkilledPlayer
extends DataContainer {
    private transient PlayerSkill skill = new PlayerSkill("none");
    private Map<String, PlayerSkill> skills = new HashMap<String, PlayerSkill>(){
        {
            this.put("none", SkilledPlayer.this.skill);
        }
    };
    private transient UUID id;
    private transient double energyBooster;
    private transient double energy;
    private double healthScaling = SkillsConfig.DEFAULT_HEALTH_SCALING.getDouble();
    private long lastSkillChange;
    private transient EidolonForm form = EidolonForm.LIGHT;
    private transient ActiveAbility lastAbilityUsed;
    private transient ActiveAbility activeReady;
    private boolean showActionBar = SkillsConfig.ACTIONBAR_DEFAULT.getBoolean();
    private Map<String, Integer> masteries = new HashMap<String, Integer>();
    private Collection<SkillsPersonalBonus> bonuses = new ArrayList<SkillsPersonalBonus>();
    private Map<String, Cosmetic> cosmetics = new HashMap<String, Cosmetic>();
    private Set<UUID> friends = new HashSet<UUID>();
    private Set<UUID> friendRequests = new HashSet<UUID>();
    private UUID party;
    private PartyRank rank;
    private final transient Set<Ability> activeAbilities = Collections.newSetFromMap(new IdentityHashMap());

    public SkilledPlayer(UUID uUID) {
        this.id = Objects.requireNonNull(uUID, "Skilled Player's UUID cannot be null");
        SkillsPro.get().getPlayerDataManager().load(this);
    }

    public SkilledPlayer() {
    }

    public static @NonNull SkilledPlayer getSkilledPlayer(@NonNull UUID uUID) {
        Objects.requireNonNull(uUID, "Cannot get skilled player data with null player UUID");
        SkilledPlayer skilledPlayer = (SkilledPlayer)SkillsPro.get().getPlayerDataManager().getData(uUID);
        if (skilledPlayer == null) {
            skilledPlayer = new SkilledPlayer(uUID);
            if (SkillsConfig.STARTER_ENABLED.getBoolean()) {
                skilledPlayer.setLevel(SkillsConfig.STARTER_LEVEL.getInt());
                skilledPlayer.setSouls(SkillsConfig.STARTER_SOULS.getLong());
                ConfigurationSection configurationSection = SkillsConfig.STARTER_STATS.getSection();
                for (Object object : configurationSection.getKeys(false)) {
                    Stat object2 = Stat.getStat((String)object);
                    if (object2 == null) continue;
                    skilledPlayer.setStat(object2, configurationSection.getInt((String)object));
                }
                int n = SkillsConfig.STARTER_MASTERIES.getInt();
                if (n > 0) {
                    for (Mastery mastery : MasteryManager.getMasteries()) {
                        skilledPlayer.masteries.put(mastery.getName(), n);
                    }
                }
            }
        }
        return skilledPlayer;
    }

    public static @NonNull SkilledPlayer getSkilledPlayer(@NonNull OfflinePlayer offlinePlayer) {
        Objects.requireNonNull(offlinePlayer, "Cannot get skilled player data for null player");
        return SkilledPlayer.getSkilledPlayer(offlinePlayer.getUniqueId());
    }

    public boolean hasSkill(Skill skill) {
        return this.skills.containsKey(skill.getName());
    }

    public Set<UUID> getFriends() {
        return this.friends;
    }

    public void setFriends(Set<UUID> set) {
        this.friends = set;
    }

    public Set<UUID> getFriendRequests() {
        return this.friendRequests;
    }

    public void setFriendRequests(Set<UUID> set) {
        this.friendRequests = set;
    }

    public @NonNull Collection<SkillsPersonalBonus> getBonuses() {
        this.removeExpiredBonuses();
        return this.bonuses;
    }

    private void removeExpiredBonuses() {
        this.bonuses.removeIf(SkillsBonus::hasExpired);
    }

    public void setBonuses(Collection<SkillsPersonalBonus> collection) {
        this.bonuses = collection;
        this.removeExpiredBonuses();
    }

    public @NonNull Collection<SkillsPersonalBonus> getBonus(SkillsEventType skillsEventType) {
        return this.getBonuses().stream().filter(skillsPersonalBonus -> skillsPersonalBonus.getType() == skillsEventType).collect(Collectors.toList());
    }

    public void addBonus(SkillsPersonalBonus skillsPersonalBonus) {
        Objects.requireNonNull(skillsPersonalBonus, "Cannot add null bonus");
        if (skillsPersonalBonus.hasExpired()) {
            throw new IllegalArgumentException("Cannot add expired bonus: " + skillsPersonalBonus);
        }
        if (!skillsPersonalBonus.getPlayerId().equals(this.id)) {
            throw new IllegalArgumentException("Bonus ids dont match: " + skillsPersonalBonus.getPlayerId() + " != " + this.id);
        }
        this.bonuses.add(skillsPersonalBonus);
    }

    public void removeBonus(SkillsEventType skillsEventType) {
        this.bonuses.removeIf(skillsPersonalBonus -> {
            if (skillsPersonalBonus.getType() == skillsEventType) {
                skillsPersonalBonus.stop();
                return true;
            }
            return false;
        });
    }

    public Set<Ability> getActiveAbilities() {
        return this.activeAbilities;
    }

    public void setActiveAbilitiy(Ability ability, boolean bl) {
        if (bl) {
            this.activeAbilities.add(ability);
        } else {
            this.activeAbilities.remove(ability);
        }
    }

    public Map<String, PlayerSkill> getSkills() {
        return this.skills;
    }

    public void setSkills(Map<String, PlayerSkill> map) {
        this.skills = map;
    }

    public double getLevelXP(int n) {
        return LevelUp.getLevel(this, n);
    }

    public double getLevelXP() {
        return this.getLevelXP(this.skill.getLevel());
    }

    public Cosmetic setCosmetic(Cosmetic cosmetic) {
        Objects.requireNonNull(cosmetic, "Cannot set null cosmetic");
        return this.cosmetics.put(cosmetic.getCategory().getName(), cosmetic);
    }

    public BukkitTask setEnergy(final double d) {
        final Player player = this.getPlayer();
        if (player == null) {
            throw new IllegalStateException("Cannot set energy of offline player: " + this.getOfflinePlayer().getName() + " - " + this.getOfflinePlayer().getLastPlayed());
        }
        return new BukkitRunnable(){

            public void run() {
                SkillEnergyChangeEvent skillEnergyChangeEvent = new SkillEnergyChangeEvent(player, SkilledPlayer.this, d);
                Bukkit.getPluginManager().callEvent((Event)skillEnergyChangeEvent);
                if (skillEnergyChangeEvent.isCancelled()) {
                    return;
                }
                SkilledPlayer.this.energy = skillEnergyChangeEvent.getAmount();
                if (SkilledPlayer.this.skill.getSkillName().equalsIgnoreCase("eidolon") && SkilledPlayer.this.energy >= SkilledPlayer.this.getScaling(SkillScaling.MAX_ENERGY)) {
                    EidolonForm eidolonForm = SkilledPlayer.this.form == EidolonForm.DARK ? EidolonForm.LIGHT : EidolonForm.DARK;
                    EidolonImbalanceChangeEvent eidolonImbalanceChangeEvent = new EidolonImbalanceChangeEvent(player, eidolonForm);
                    Bukkit.getPluginManager().callEvent((Event)eidolonImbalanceChangeEvent);
                    SkilledPlayer.this.form = eidolonImbalanceChangeEvent.getNewForm();
                    SkilledPlayer.this.energy = 0.0;
                }
            }
        }.runTaskAsynchronously((Plugin)SkillsPro.get());
    }

    public void setCooldown(long l) {
        new Cooldown(this.id, "CD", l);
    }

    public long getCooldownTimeLeft() {
        return Cooldown.getTimeLeft(this.id, "CD");
    }

    public boolean isInCooldown() {
        return Cooldown.isInCooldown(this.id, "CD");
    }

    public boolean showReadyMessage() {
        return this.skill.showReadyMessage();
    }

    public void setShowReadyMessage(boolean bl) {
        this.skill.setShowReadyMessage(bl);
    }

    public @NonNull UUID getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getCompressedData() {
        return this.skill + SkilledPlayer.compressUUID(this.party) + (this.rank == null ? "" : Integer.valueOf(this.rank.ordinal())) + (this.healthScaling == 0.0 ? "" : Double.valueOf(this.healthScaling)) + SkilledPlayer.compressCollecton(this.bonuses, SkillsBonus::toString) + SkilledPlayer.compressCollecton(this.masteries.values(), n -> n) + SkilledPlayer.compressCollecton(this.friends, uUID -> DataContainer.compressUUID(uUID)) + SkilledPlayer.compressCollecton(this.friendRequests, uUID -> DataContainer.compressUUID(uUID)) + SkilledPlayer.compressCollecton(this.skills.values(), PlayerSkill::getCompressedData);
    }

    @Override
    public @NonNull String getKey() {
        return FastUUID.toString(this.id);
    }

    @Override
    public void setIdentifier(@NonNull String string) {
        this.id = FastUUID.fromString(string);
        this.bonuses.forEach(skillsPersonalBonus -> skillsPersonalBonus.setPlayerId(this.id));
    }

    public @NonNull Skill getSkill() {
        Skill skill = this.skill.getSkill();
        if (skill == null) {
            MessageHandler.sendConsolePluginMessage("&4Unable to find skill (class) with name &e" + this.skill.skill + " &4for player&8: &e" + this.getOfflinePlayer().getName() + " &8(&e" + this.id + "&8)");
            MessageHandler.sendConsolePluginMessage("&4Internal skill names might've been changed in the Skills folder. Defaulting back to 'none' skill");
            this.skill = new PlayerSkill("none");
            skill = this.skill.getSkill();
            if (skill == null) {
                throw new AssertionError((Object)"Cannot find the default skill: none");
            }
        }
        return skill;
    }

    public void setAbsoluteActiveSkill(@NonNull PlayerSkill playerSkill) {
        this.skill = Objects.requireNonNull(playerSkill, "Active player skill cannot be null");
    }

    public int getLevel() {
        return this.skill.level;
    }

    public void setLevel(int n) {
        this.skill.setLevel(n);
    }

    public void addLevel(int n) {
        this.setLevel(this.skill.level + n);
        this.skill.xp = Math.min(this.getXP(), this.getLevelXP());
    }

    public double getXP() {
        return this.skill.getXP();
    }

    public void setXP(double d) {
        this.setXP(d, false);
    }

    public void setXP(double d, boolean bl) {
        if (d == 0.0) {
            this.setAbsoluteXP(0.0);
            return;
        }
        if (d < 0.0) {
            this.decreaseXP(Math.abs(d));
            return;
        }
        int n = 0;
        int n2 = 0;
        while (true) {
            double d2;
            double d3 = this.getLevelXP(this.getLevel() + n2++);
            if (!(d >= d2)) break;
            d -= d3;
            ++n;
        }
        if (bl) {
            this.addLevel(n);
        } else {
            this.levelUp(n);
        }
        this.setAbsoluteXP(d);
    }

    public void setAbsoluteXP(double d) {
        this.skill.setAbsoluteXP(d);
    }

    public void chargeEnergy() {
        this.chargeEnergy(0.0);
    }

    public void chargeEnergy(double d) {
        Skill skill = this.getSkill();
        if (!Cooldown.isInCooldown(this.id, "ENERGY_BOOSTER")) {
            this.energyBooster = 0.0;
        }
        double d2 = skill.getScaling(this, SkillScaling.MAX_ENERGY);
        double d3 = skill.getScaling(this, SkillScaling.ENERGY_REGEN) + d + (d <= 0.0 ? 0.0 : this.energyBooster);
        double d4 = this.energy;
        if (d4 >= d2) {
            return;
        }
        d4 = this.energy + d3 >= d2 ? d2 : (d4 += d3);
        this.setEnergy(d4);
        if (d4 >= d2) {
            XSound.play(this.getSkill().getEnergy().getSoundFull(), soundPlayer -> soundPlayer.forPlayers(this.getPlayer()));
        }
    }

    public void addXP(double d) {
        this.addXP(d, false);
    }

    public void addSouls(long l) {
        this.skill.souls += l;
    }

    public boolean hasSounds(long l) {
        return this.skill.souls >= l;
    }

    public void addXP(double d, boolean bl) {
        if (d == 0.0) {
            return;
        }
        if (d < 0.0) {
            this.decreaseXP(-d);
        } else {
            this.setXP(this.skill.xp + d, bl);
        }
    }

    public String getSkillName() {
        return this.skill.skill;
    }

    private void decreaseXP(double d) {
        if (d == 0.0) {
            return;
        }
        for (d = Math.abs(d); this.getXP() < d; d -= this.getXP()) {
            if (this.getLevel() <= 0) {
                this.setLevel(0);
                this.setAbsoluteXP(0.0);
                return;
            }
            this.addLevel(-1);
            this.setAbsoluteXP(this.getLevelXP(this.getLevel()));
        }
        this.setAbsoluteXP(this.getXP() - d);
    }

    public void setRawXP(double d, boolean bl) {
        this.setLevel(0);
        this.setXP(d, bl);
    }

    public double getRawXP() {
        if (this.getLevel() < 1) {
            return this.getXP();
        }
        return this.getXP() + this.getLevelXP(this.getLevel() - 1);
    }

    public boolean willLevelUp(double d) {
        return this.getXP() + d >= this.getLevelXP(this.getLevel());
    }

    public long getSouls() {
        return this.skill.getSouls();
    }

    public void setSouls(long l) {
        this.skill.setSouls(l);
    }

    public boolean hasSkill() {
        return !this.skill.skill.equals("none");
    }

    public int getMasteryLevel(Mastery mastery) {
        return this.masteries.getOrDefault(mastery.getName().toLowerCase(), 0);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SkilledPlayer)) {
            return false;
        }
        SkilledPlayer skilledPlayer = (SkilledPlayer)object;
        return this.id.equals(skilledPlayer.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void setScaledHealth() {
        Player player = Objects.requireNonNull(this.getPlayer(), "Cannot scale an offline players health");
        if (this.healthScaling < 0.0) {
            MessageHandler.sendConsolePluginMessage("&cInvalid health scaling for " + player.getName() + ": " + this.healthScaling + ". Resetting...");
            this.healthScaling = 0.0;
            return;
        }
        if (this.healthScaling == 0.0) {
            player.setHealthScaled(false);
            return;
        }
        if (!player.isHealthScaled()) {
            player.setHealthScaled(true);
        }
        player.setHealthScale(this.healthScaling);
    }

    public boolean hasAbility(Ability ability) {
        return this.getSkill().hasAbility(ability);
    }

    public boolean isActiveReady(ActiveAbility activeAbility) {
        return activeAbility == this.activeReady;
    }

    public boolean setActiveReady(ActiveAbility activeAbility, boolean bl) {
        if (bl ? this.isActiveReady(activeAbility) : !this.isActiveReady()) {
            return false;
        }
        Player player = this.getPlayer();
        if (player == null) {
            throw new IllegalArgumentException("Cannot change an offline player ability state");
        }
        SkillActiveStateChangeEvent skillActiveStateChangeEvent = new SkillActiveStateChangeEvent(player, activeAbility, bl);
        Bukkit.getPluginManager().callEvent((Event)skillActiveStateChangeEvent);
        if (skillActiveStateChangeEvent.isCancelled()) {
            return false;
        }
        this.activeReady = bl ? activeAbility : null;
        return true;
    }

    public void deactivateReady() {
        this.activeReady = null;
    }

    public ActiveAbility getActiveReady() {
        return this.activeReady;
    }

    public boolean isActiveReady() {
        return this.activeReady != null;
    }

    public double getScaling(SkillScaling skillScaling) {
        return this.getSkill().getScaling(this, skillScaling);
    }

    public void levelUp(int n) {
        if (n == 0) {
            return;
        }
        Player player = this.getPlayer();
        if (player != null) {
            int n2 = (int)this.getScaling(SkillScaling.MAX_LEVEL);
            int n3 = this.getLevel() + n;
            if (this.skill.level >= n2) {
                SkillsLang.MAX_LEVEL.sendMessage(player, new Object[0]);
                return;
            }
            if (n3 > n2) {
                n = n3 - n2;
            }
            SkillLevelUpEvent skillLevelUpEvent = new SkillLevelUpEvent(this, player, n);
            Bukkit.getPluginManager().callEvent((Event)skillLevelUpEvent);
            if (skillLevelUpEvent.isCancelled()) {
                return;
            }
            LevelManager.onLevelUp(skillLevelUpEvent);
            n = skillLevelUpEvent.getAddedLevel();
        }
        this.setLevel(this.getLevel() + n);
        this.skill.xp = 0.0;
    }

    public boolean canChangeSkill() {
        if (this.lastSkillChange < 1L) {
            return true;
        }
        long l = SkillsConfig.SKILL_CHANGE_COOLDOWN.getTimeMillis();
        if (l < 0L) {
            return false;
        }
        if (l == 0L) {
            return true;
        }
        return System.currentTimeMillis() - this.lastSkillChange > l;
    }

    public long getTimeLeftToChangeSkill() {
        long l = SkillsConfig.SKILL_CHANGE_COOLDOWN.getTimeMillis();
        if (l < 1L) {
            return 0L;
        }
        long l2 = System.currentTimeMillis() - this.lastSkillChange;
        if (l2 < 1L) {
            return 0L;
        }
        return Math.abs(l - l2);
    }

    public String getTimeLeftToChangeSkillString() {
        return new NoEpochDate(this.getTimeLeftToChangeSkill()).format(SkillsConfig.TIME_FORMAT.getString());
    }

    public void changedSkill() {
        this.lastSkillChange = System.currentTimeMillis();
    }

    public @NonNull OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.id);
    }

    public @Nullable Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.id);
    }

    public EidolonForm getForm() {
        return this.form;
    }

    public void setForm(@NonNull EidolonForm eidolonForm) {
        this.form = eidolonForm;
    }

    public void toggleAbility(Ability ability) {
        PlayerAbilityData playerAbilityData = this.skill.getAbilityData(ability);
        boolean bl = !playerAbilityData.isDisabled();
        playerAbilityData.setDisabled(bl);
        SkillToggleAbilityEvent skillToggleAbilityEvent = new SkillToggleAbilityEvent(this.getPlayer(), ability, bl);
        Bukkit.getPluginManager().callEvent((Event)skillToggleAbilityEvent);
    }

    public boolean isAbilityDisabled(Ability ability) {
        return this.skill.getAbilityData(ability).isDisabled();
    }

    public boolean hasParty() {
        return this.party != null;
    }

    public void upgradeAbility(@NonNull Ability ability) {
        this.addAbilityLevel(ability, 1);
        SkillImproveEvent skillImproveEvent = new SkillImproveEvent(this.getPlayer(), ability);
        Bukkit.getPluginManager().callEvent((Event)skillImproveEvent);
    }

    public int getStat(@NonNull String string) {
        return this.skill.getStats().getOrDefault(string.toUpperCase(Locale.ENGLISH), 0);
    }

    public int getStat(@Nonnull Stat stat) {
        return this.getStat(stat.getDataNode());
    }

    public int getPoints() {
        return this.getStat(Stat.POINTS.getDataNode());
    }

    public void addStat(@NonNull String string, int n) {
        this.setStat(string, this.getStat(string) + n);
    }

    public void addStat(Stat stat, int n) {
        this.addStat(stat.getDataNode(), n);
    }

    public void setStat(@NonNull String string, int n) {
        this.skill.getStats().put(string, n);
    }

    public void setStat(@Nonnull Stat stat, int n) {
        this.skill.getStats().put(stat.getDataNode(), n);
    }

    public int resetStats() {
        return this.skill.resetStats();
    }

    public Map<String, Integer> getStats() {
        return this.skill.getStats();
    }

    public void setMasteryLevel(@NonNull Mastery mastery, int n) {
        this.masteries.put(mastery.getName().toLowerCase(), n);
    }

    public void addMasteryLevel(@NonNull Mastery mastery, int n) {
        if (n != 0) {
            this.setMasteryLevel(mastery, this.getMasteryLevel(mastery) + n);
        }
    }

    public @NonNull Map<String, Integer> getMasteries() {
        return this.masteries;
    }

    public void setMasteries(@NonNull HashMap<String, Integer> hashMap) {
        this.masteries = hashMap;
    }

    public Map<String, PlayerAbilityData> getAbilities() {
        return this.skill.abilities;
    }

    public void setAbilityLevel(@NonNull Ability ability, int n) {
        this.skill.setAbilityLevel(ability, n);
    }

    public void addAbilityLevel(@NonNull Ability ability, int n) {
        this.skill.addAbilityLevel(ability, n);
    }

    public int getAbilityLevel(@NonNull Ability ability) {
        return this.skill.getAbilityLevel(ability);
    }

    public PlayerAbilityData getAbilityData(Ability ability) {
        return this.skill.getAbilityData(ability);
    }

    public long getLastSkillChange() {
        return this.lastSkillChange;
    }

    public void setLastSkillChange(long l) {
        this.lastSkillChange = l;
    }

    public List<OfflinePlayer> getPlayerFriends() {
        ArrayList<OfflinePlayer> arrayList = new ArrayList<OfflinePlayer>(this.friends.size());
        for (UUID uUID : this.friends) {
            arrayList.add(Bukkit.getOfflinePlayer((UUID)uUID));
        }
        return arrayList;
    }

    public UUID getPartyId() {
        return this.party;
    }

    public SkillsParty getParty() {
        if (this.party == null) {
            return null;
        }
        SkillsParty skillsParty = SkillsParty.getParty(this.party);
        if (skillsParty == null && this.party != null) {
            MessageHandler.sendConsolePluginMessage("&4Invalid party data for &e" + this.getOfflinePlayer().getName() + "&4. Removing them from party now... Please do not report if any error occured after this message.");
            this.party = null;
            this.rank = null;
        }
        return skillsParty;
    }

    public void setParty(SkillsParty skillsParty) {
        this.party = skillsParty.getId();
    }

    public void setParty(UUID uUID) {
        this.party = uUID;
    }

    public void joinParty(SkillsParty skillsParty) {
        this.setParty(skillsParty);
        skillsParty.getMembers().add(this.id);
        this.rank = PartyRank.MEMBER;
    }

    public PlayerSkill getActiveSkill() {
        return this.skill;
    }

    public void setActiveSkill(@NonNull String string) {
        PlayerSkill playerSkill = this.skills.get(string);
        if (playerSkill == null) {
            playerSkill = new PlayerSkill(string);
            this.skills.put(string, playerSkill);
        }
        if (SkillsConfig.SKILLS_SHARED_DATA_SOULS.getBoolean()) {
            playerSkill.setSouls(this.getSouls());
        }
        if (SkillsConfig.SKILLS_SHARED_DATA_STATS.getBoolean()) {
            playerSkill.setStats(this.getStats());
        }
        if (SkillsConfig.SKILLS_SHARED_DATA_LEVELS.getBoolean()) {
            playerSkill.setLevel(this.getLevel());
            playerSkill.setAbsoluteXP(this.getXP());
        }
        this.skills.put(this.skill.skill, this.skill);
        this.skill = playerSkill;
    }

    public ClassChangeEvent setActiveSkill(@NonNull Skill skill) {
        ClassChangeEvent classChangeEvent = new ClassChangeEvent(this, skill);
        Bukkit.getPluginManager().callEvent((Event)classChangeEvent);
        if (classChangeEvent.isCancelled()) {
            return classChangeEvent;
        }
        skill = classChangeEvent.getNewSkill();
        this.setActiveSkill(skill.getName());
        this.changedSkill();
        return classChangeEvent;
    }

    public void leaveParty() {
        this.getParty().getMembers().remove(this.id);
        this.party = null;
        this.rank = null;
    }

    public void friendRequest(Player player) {
        this.friendRequests.add(player.getUniqueId());
    }

    public void settleFriendRequest(Player player) {
        this.friendRequests.remove(player.getUniqueId());
    }

    public PartyRank getRank() {
        return this.rank;
    }

    public void setRank(PartyRank partyRank) {
        this.rank = partyRank;
    }

    public boolean isFrendly(SkilledPlayer skilledPlayer) {
        if (this.friends.contains(skilledPlayer.id)) {
            return true;
        }
        return this.party != null && this.party.equals(skilledPlayer.party);
    }

    public boolean isFrendly(OfflinePlayer offlinePlayer) {
        return this.isFrendly(SkilledPlayer.getSkilledPlayer(offlinePlayer));
    }

    public double getHealthScaling() {
        return this.healthScaling;
    }

    public void setHealthScaling(double d) {
        this.healthScaling = d;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getEnergyBooster() {
        return this.energyBooster;
    }

    public void setEnergyBooster(double d) {
        this.energyBooster = d;
    }

    public ActiveAbility getLastAbilityUsed() {
        return this.lastAbilityUsed;
    }

    public void setLastAbilityUsed(ActiveAbility activeAbility) {
        this.lastAbilityUsed = activeAbility;
    }

    public Map<String, Cosmetic> getCosmetics() {
        return this.cosmetics;
    }

    public void setCosmetics(Map<String, Cosmetic> map) {
        this.cosmetics = map;
    }

    public Cosmetic getCosmetic(String string) {
        Cosmetic cosmetic = this.cosmetics.get(string);
        if (cosmetic != null) {
            return cosmetic;
        }
        CosmeticCategory cosmeticCategory = CosmeticCategory.CATEGORIES.get(string);
        if (cosmeticCategory != null) {
            return cosmeticCategory.getCosmetics().get("none");
        }
        return null;
    }

    public boolean showActionBar() {
        return this.showActionBar;
    }

    public void setShowActionBar(boolean bl) {
        this.showActionBar = bl;
    }
}

