/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.managers;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.skills.abilities.Ability;
import org.skills.abilities.KeyBinding;
import org.skills.data.database.DataContainer;
import org.skills.data.managers.PlayerAbilityData;
import org.skills.main.SkillsConfig;
import org.skills.types.Skill;
import org.skills.types.SkillManager;
import org.skills.types.Stat;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

public class PlayerSkill
extends DataContainer {
    public static final String NONE = "none";
    public static final boolean SHARED_LEVELS = SkillsConfig.SKILLS_SHARED_DATA_LEVELS.getBoolean();
    public static final boolean SHARED_SOULS = SkillsConfig.SKILLS_SHARED_DATA_SOULS.getBoolean();
    public static final boolean SHARED_STATS = SkillsConfig.SKILLS_SHARED_DATA_STATS.getBoolean();
    protected final String skill;
    protected int level;
    protected double xp;
    protected long souls;
    protected boolean showReadyMessage = true;
    protected Map<String, PlayerAbilityData> abilities = new HashMap<String, PlayerAbilityData>();
    protected Map<String, Integer> stats = new HashMap<String, Integer>();

    public PlayerSkill(String string) {
        this.skill = string;
    }

    @Override
    public @NonNull String getCompressedData() {
        return (double)this.level + this.xp + (double)this.souls + PlayerSkill.compressBoolean(this.showReadyMessage) + PlayerSkill.compressCollecton(this.abilities.values(), playerAbilityData -> PlayerSkill.compressBoolean(playerAbilityData.isDisabled()) + playerAbilityData.getLevel() + (playerAbilityData.getKeyBinding() == null ? "" : KeyBinding.toString(playerAbilityData.getKeyBinding()))) + PlayerSkill.compressCollecton(this.stats.values(), n -> n);
    }

    public boolean showReadyMessage() {
        return this.showReadyMessage;
    }

    public void setShowReadyMessage(boolean bl) {
        this.showReadyMessage = bl;
    }

    public @Nullable Skill getSkill() {
        return SkillManager.getSkill(this.skill);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public double getXP() {
        return this.xp;
    }

    public void setAbsoluteXP(double d) {
        this.xp = d;
    }

    public void addSouls(int n) {
        this.souls += (long)n;
    }

    public String getSkillName() {
        return this.skill;
    }

    public long getSouls() {
        return this.souls;
    }

    public void setSouls(long l) {
        this.souls = l;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("PlayerSkill doesn't have a hashcode");
    }

    public boolean equals(Object object) {
        throw new UnsupportedOperationException("PlayerSkill equals() should not be called");
    }

    public String toString() {
        return this.skill + this.abilities + this.souls + this.xp + this.level + this.stats + this.showReadyMessage;
    }

    public int getStat(@NonNull String string) {
        return this.stats.getOrDefault(string.toUpperCase(Locale.ENGLISH), 0);
    }

    public int getStat(@Nonnull Stat stat) {
        return this.getStat(stat.getDataNode());
    }

    public int getPoints() {
        return this.getStat(Stat.POINTS.getDataNode());
    }

    public void addStat(@NonNull String string, int n) {
        this.setStat(string, this.getStat(string) + n);
    }

    public void addStat(Stat stat, int n) {
        this.addStat(stat.getDataNode(), n);
    }

    public void setStat(@NonNull String string, int n) {
        this.stats.put(string, n);
    }

    public void setStat(@Nonnull Stat stat, int n) {
        this.stats.put(stat.getDataNode(), n);
    }

    public int resetStats() {
        int n = 0;
        for (Map.Entry<String, Integer> entry : this.stats.entrySet()) {
            n += entry.getValue().intValue();
            this.setStat(entry.getKey(), 0);
        }
        this.setStat(Stat.POINTS, n);
        return n;
    }

    public Map<String, Integer> getStats() {
        return this.stats;
    }

    public void setStats(Map<String, Integer> map) {
        Objects.requireNonNull(map, "Player stats cannot be null");
        this.stats = map;
    }

    public Map<String, PlayerAbilityData> getAbilities() {
        return this.abilities;
    }

    public void setAbilities(@NonNull Map<String, PlayerAbilityData> map) {
        this.abilities = map;
    }

    public void setAbilityLevel(@NonNull Ability ability, int n) {
        PlayerAbilityData playerAbilityData = this.abilities.get(ability.getName());
        if (playerAbilityData == null) {
            playerAbilityData = this.getDataOrDefault(ability);
        }
        playerAbilityData.setLevel(n);
        this.abilities.put(ability.getName(), playerAbilityData);
    }

    public void addAbilityLevel(@NonNull Ability ability, int n) {
        PlayerAbilityData playerAbilityData = this.abilities.get(ability.getName());
        if (playerAbilityData == null) {
            playerAbilityData = this.getDataOrDefault(ability);
        }
        playerAbilityData.addLevel(n);
        this.abilities.put(ability.getName(), playerAbilityData);
    }

    public PlayerAbilityData getAbilityData(@NonNull Ability ability) {
        PlayerAbilityData playerAbilityData = this.abilities.get(ability.getName());
        if (playerAbilityData == null) {
            playerAbilityData = this.getDataOrDefault(ability);
        }
        return playerAbilityData;
    }

    public PlayerAbilityData getDataOrDefault(Ability ability) {
        PlayerAbilityData playerAbilityData = null;
        if (this.getSkill().hasAbility(ability)) {
            playerAbilityData = new PlayerAbilityData();
            this.abilities.put(ability.getName(), playerAbilityData);
        }
        return playerAbilityData;
    }

    public int getAbilityLevel(@NonNull Ability ability) {
        PlayerAbilityData playerAbilityData = this.getAbilityData(ability);
        return playerAbilityData == null ? 0 : playerAbilityData.getLevel();
    }

    @Override
    public @NonNull String getKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIdentifier(@NonNull String string) {
        throw new UnsupportedOperationException();
    }
}

