/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.managers;

import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.data.database.DataContainer;
import org.skills.data.database.SkillsDatabase;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.utils.CacheHandler;
import org.skills.utils.FastUUID;
import org.skills.utils.caffeine.cache.CacheLoader;
import org.skills.utils.caffeine.cache.LoadingCache;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

public abstract class DataManager<T extends DataContainer> {
    private static final long INTERVAL = SkillsConfig.AUTOSAVE_INTERVAL.getTimeMillis(TimeUnit.MINUTES);
    public SkillsDatabase<T> database;
    protected final LoadingCache<UUID, T> cache = CacheHandler.newBuilder().expireAfterAccess(INTERVAL * 2L, TimeUnit.MILLISECONDS).build(new CacheLoader<UUID, T>(){

        @Override
        public @Nullable T load(@NonNull UUID uUID) {
            return DataManager.this.database.load(FastUUID.toString(uUID));
        }
    });

    public DataManager(SkillsDatabase<T> skillsDatabase) {
        this.database = skillsDatabase;
    }

    public void delete(@NonNull UUID uUID) {
        this.unload(uUID);
        this.database.delete(uUID.toString());
    }

    protected void autoSave(@NonNull SkillsPro skillsPro) {
        long l = INTERVAL;
        l = TimeUnit.MILLISECONDS.toSeconds(l);
        new BukkitRunnable(){

            public void run() {
                DataManager.this.saveAll();
            }
        }.runTaskTimerAsynchronously((Plugin)skillsPro, l *= 20L, l);
    }

    public void saveAll() {
        for (DataContainer dataContainer : this.cache.asMap().values()) {
            if (!dataContainer.shouldSave()) continue;
            this.save(dataContainer);
        }
    }

    public void save(@NonNull T t) {
        this.database.save(t);
    }

    public void unload(@NonNull UUID uUID) {
        this.cache.invalidate(uUID);
    }

    public void load(T t) {
        this.cache.put(FastUUID.fromString(((DataContainer)t).getKey()), t);
    }

    public @Nullable T peek(@NonNull UUID uUID) {
        DataContainer dataContainer = (DataContainer)this.cache.getIfPresent(uUID);
        if (dataContainer != null) {
            return (T)dataContainer;
        }
        this.database.load(FastUUID.toString(uUID));
        return (T)dataContainer;
    }

    public @Nullable T getData(@NonNull UUID uUID) {
        return (T)((DataContainer)this.cache.get(uUID));
    }

    public Collection<T> getAllData() {
        @NonNull String[] stringArray = this.database.getAllKeys();
        HashMap hashMap = new HashMap(stringArray.length);
        hashMap.putAll(this.cache.asMap());
        for (String string : stringArray) {
            UUID uUID = FastUUID.fromString(string);
            hashMap.computeIfAbsent(uUID, uUID2 -> (DataContainer)this.cache.get(uUID));
        }
        return hashMap.values();
    }
}

