/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.database.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.skills.data.database.json.AdapterSharedSkillsData;
import org.skills.data.managers.Cosmetic;
import org.skills.data.managers.CosmeticCategory;
import org.skills.data.managers.PlayerSkill;
import org.skills.data.managers.SkilledPlayer;
import org.skills.events.SkillsPersonalBonus;
import org.skills.party.PartyRank;
import org.skills.utils.FastUUID;

public class AdapterSkilledPlayer
implements JsonSerializer<SkilledPlayer>,
JsonDeserializer<SkilledPlayer> {
    public SkilledPlayer deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        Object object;
        JsonElement jsonElement2;
        JsonElement jsonElement3;
        JsonElement jsonElement4;
        SkilledPlayer skilledPlayer = new SkilledPlayer();
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        Type type2 = new TypeToken<Map<String, PlayerSkill>>(){}.getType();
        skilledPlayer.setSkills((Map)jsonDeserializationContext.deserialize(jsonObject.get("skills"), type2));
        PlayerSkill playerSkill = skilledPlayer.getSkills().get(jsonObject.get("skill").getAsString());
        if (playerSkill == null) {
            playerSkill = new PlayerSkill("none");
        }
        AdapterSharedSkillsData.deserialize(jsonElement, playerSkill, true);
        skilledPlayer.setAbsoluteActiveSkill(playerSkill);
        JsonElement jsonElement5 = jsonObject.get("showActionBar");
        if (jsonElement5 != null) {
            skilledPlayer.setShowActionBar(jsonElement5.getAsBoolean());
        }
        skilledPlayer.setLastSkillChange((jsonElement4 = jsonObject.get("lastSkillChange")) == null ? 0L : jsonElement4.getAsLong());
        Type type3 = new TypeToken<Set<UUID>>(){}.getType();
        Set set = (Set)jsonDeserializationContext.deserialize(jsonObject.get("friends"), type3);
        Set set2 = (Set)jsonDeserializationContext.deserialize(jsonObject.get("friendRequests"), type3);
        if (set != null) {
            skilledPlayer.setFriends(set);
        }
        if (set2 != null) {
            skilledPlayer.setFriendRequests(set2);
        }
        if ((jsonElement3 = jsonObject.get("healthScaling")) != null) {
            skilledPlayer.setHealthScaling(jsonElement3.getAsDouble());
        }
        if ((jsonElement2 = jsonObject.get("party")) != null) {
            skilledPlayer.setParty(FastUUID.fromString(jsonElement2.getAsString()));
        }
        skilledPlayer.setRank((PartyRank)((Object)jsonDeserializationContext.deserialize(jsonObject.get("rank"), PartyRank.class)));
        type2 = new TypeToken<HashMap<String, Integer>>(){}.getType();
        skilledPlayer.setMasteries((HashMap)jsonDeserializationContext.deserialize(jsonObject.get("masteries"), type2));
        type2 = new TypeToken<List<SkillsPersonalBonus>>(){}.getType();
        try {
            object = (List)jsonDeserializationContext.deserialize(jsonObject.get("bonuses"), type2);
            skilledPlayer.setBonuses((Collection<SkillsPersonalBonus>)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = jsonObject.get("cosmetics");
        if (object != null) {
            type2 = new TypeToken<Map<String, String>>(){}.getType();
            Map map = (Map)jsonDeserializationContext.deserialize(object, type2);
            HashMap<String, Cosmetic> hashMap = new HashMap<String, Cosmetic>();
            for (Map.Entry entry : map.entrySet()) {
                CosmeticCategory cosmeticCategory = CosmeticCategory.get((String)entry.getKey());
                if (cosmeticCategory == null) continue;
                hashMap.put(cosmeticCategory.getName(), cosmeticCategory.getCosmetic((String)entry.getValue()));
            }
            skilledPlayer.setCosmetics(hashMap);
        }
        return skilledPlayer;
    }

    public JsonElement serialize(SkilledPlayer skilledPlayer, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject2 = new JsonObject();
        AdapterSharedSkillsData.serialize(jsonObject2, skilledPlayer.getActiveSkill(), true);
        jsonObject2.addProperty("skill", skilledPlayer.getSkillName());
        jsonObject2.addProperty("showActionBar", Boolean.valueOf(skilledPlayer.showActionBar()));
        jsonObject2.addProperty("lastSkillChange", (Number)skilledPlayer.getLastSkillChange());
        Type type2 = new TypeToken<Set<UUID>>(){}.getType();
        jsonObject2.addProperty("healthScaling", (Number)skilledPlayer.getHealthScaling());
        jsonObject2.add("friends", jsonSerializationContext.serialize(skilledPlayer.getFriends(), type2));
        jsonObject2.add("friendRequests", jsonSerializationContext.serialize(skilledPlayer.getFriendRequests(), type2));
        if (skilledPlayer.hasParty()) {
            jsonObject2.addProperty("party", FastUUID.toString(skilledPlayer.getPartyId()));
        }
        jsonObject2.addProperty("rank", skilledPlayer.getRank() == null ? null : skilledPlayer.getRank().name());
        JsonObject jsonObject3 = new JsonObject();
        for (Map.Entry<String, PlayerSkill> jsonObject4 : skilledPlayer.getSkills().entrySet()) {
            jsonObject3.add(jsonObject4.getKey(), jsonSerializationContext.serialize((Object)jsonObject4.getValue()));
        }
        jsonObject2.add("skills", (JsonElement)jsonObject3);
        Object object = new TypeToken<HashMap<String, Integer>>(){}.getType();
        jsonObject2.add("masteries", jsonSerializationContext.serialize(skilledPlayer.getMasteries(), (Type)object));
        object = new TypeToken<Collection<SkillsPersonalBonus>>(){}.getType();
        jsonObject2.add("bonuses", jsonSerializationContext.serialize(skilledPlayer.getBonuses(), (Type)object));
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<String, Cosmetic> entry : skilledPlayer.getCosmetics().entrySet()) {
            jsonObject.addProperty(entry.getKey(), entry.getValue().getName());
        }
        jsonObject2.add("cosmetics", (JsonElement)jsonObject);
        return jsonObject2;
    }
}

