/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.database.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import org.skills.data.managers.PlayerSkill;
import org.skills.types.Stat;

public class AdapterSharedSkillsData {
    public static void deserialize(JsonElement jsonElement, PlayerSkill playerSkill, boolean bl) {
        JsonElement jsonElement2;
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (PlayerSkill.SHARED_LEVELS == bl && (jsonElement2 = jsonObject.get("level")) != null) {
            playerSkill.setLevel(jsonElement2.getAsInt());
            playerSkill.setAbsoluteXP(jsonObject.get("xp").getAsDouble());
        }
        if (PlayerSkill.SHARED_SOULS == bl && (jsonElement2 = jsonObject.get("souls")) != null) {
            playerSkill.setSouls(jsonElement2.getAsLong());
        }
        if (PlayerSkill.SHARED_STATS == bl) {
            jsonElement2 = jsonObject.get("stats").getAsJsonObject();
            for (Map.Entry entry : jsonElement2.entrySet()) {
                playerSkill.setStat((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
            }
        }
    }

    public static JsonElement serialize(JsonObject jsonObject, PlayerSkill playerSkill, boolean bl) {
        if (PlayerSkill.SHARED_LEVELS == bl) {
            jsonObject.addProperty("level", (Number)playerSkill.getLevel());
            jsonObject.addProperty("xp", (Number)playerSkill.getXP());
        }
        if (PlayerSkill.SHARED_SOULS == bl) {
            jsonObject.addProperty("souls", (Number)playerSkill.getSouls());
        }
        if (PlayerSkill.SHARED_STATS == bl) {
            JsonObject jsonObject2 = new JsonObject();
            for (Stat stat : Stat.STATS.values()) {
                int n = playerSkill.getStat(stat);
                if (n == 0) continue;
                jsonObject2.addProperty(stat.getDataNode(), (Number)n);
            }
            jsonObject.add("stats", (JsonElement)jsonObject2);
        }
        return jsonObject;
    }
}

