/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.database.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.skills.abilities.KeyBinding;
import org.skills.data.database.json.AdapterSharedSkillsData;
import org.skills.data.managers.PlayerAbilityData;
import org.skills.data.managers.PlayerSkill;

public class AdapterPlayerSkill
implements JsonSerializer<PlayerSkill>,
JsonDeserializer<PlayerSkill> {
    public PlayerSkill deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        String string = jsonObject.get("skill").getAsString();
        PlayerSkill playerSkill = new PlayerSkill(string);
        AdapterSharedSkillsData.deserialize(jsonElement, playerSkill, false);
        playerSkill.setShowReadyMessage(jsonObject.get("showReadyMessage").getAsBoolean());
        JsonObject jsonObject2 = jsonObject.get("abilities").getAsJsonObject();
        HashMap<String, PlayerAbilityData> hashMap = new HashMap<String, PlayerAbilityData>(jsonObject2.size());
        for (Map.Entry entry : jsonObject2.entrySet()) {
            PlayerAbilityData playerAbilityData = new PlayerAbilityData();
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                JsonElement jsonElement2;
                JsonElement jsonElement3;
                JsonObject jsonObject3 = ((JsonElement)entry.getValue()).getAsJsonObject();
                JsonElement jsonElement4 = jsonObject3.get("level");
                if (jsonElement4 != null) {
                    playerAbilityData.setLevel(jsonElement4.getAsInt());
                }
                if ((jsonElement3 = jsonObject3.get("disabled")) != null) {
                    playerAbilityData.setDisabled(jsonElement3.getAsBoolean());
                }
                if ((jsonElement2 = jsonObject3.get("key-binding")) != null) {
                    playerAbilityData.setKeyBinding(jsonElement2.getAsString());
                }
            } else {
                playerAbilityData.setLevel(((JsonElement)entry.getValue()).getAsInt());
            }
            hashMap.put((String)entry.getKey(), playerAbilityData);
        }
        playerSkill.setAbilities(hashMap);
        return playerSkill;
    }

    public JsonElement serialize(PlayerSkill playerSkill, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("skill", playerSkill.getSkillName());
        AdapterSharedSkillsData.serialize(jsonObject, playerSkill, false);
        jsonObject.addProperty("showReadyMessage", Boolean.valueOf(playerSkill.showReadyMessage()));
        JsonObject jsonObject2 = new JsonObject();
        Map<String, PlayerAbilityData> map = playerSkill.getAbilities();
        for (Map.Entry<String, PlayerAbilityData> entry : map.entrySet()) {
            JsonObject jsonObject3 = new JsonObject();
            PlayerAbilityData playerAbilityData = entry.getValue();
            boolean bl = false;
            if (playerAbilityData.isDisabled()) {
                jsonObject3.addProperty("disabled", Boolean.valueOf(true));
                bl = true;
            }
            if (playerAbilityData.getKeyBinding() != null) {
                jsonObject3.addProperty("key-binding", KeyBinding.toString(playerAbilityData.getKeyBinding()));
                bl = true;
            }
            if (playerAbilityData.getLevel() != 0) {
                jsonObject3.addProperty("level", (Number)playerAbilityData.getLevel());
                bl = true;
            }
            if (!bl) continue;
            jsonObject2.add(entry.getKey(), (JsonElement)jsonObject3);
        }
        jsonObject.add("abilities", (JsonElement)jsonObject2);
        return jsonObject;
    }
}

