/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.user.AmountChangeFactory;
import org.skills.commands.user.CommandUser;
import org.skills.main.locale.SkillsLang;

public class CommandUserXP
extends SkillsCommand {
    public CommandUserXP(SkillsCommand skillsCommand) {
        super("xp", skillsCommand, SkillsLang.COMMAND_USER_XP_DESCRIPTION, false, "exp");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        CommandUser.handle(this, commandSender, stringArray, (amountChangeFactory, offlinePlayer, skilledPlayer, bl) -> {
            double d = bl ? skilledPlayer.getRawXP() : skilledPlayer.getXP();
            int n = (int)amountChangeFactory.withInitialAmount(d).getFinalAmount();
            if (bl) {
                skilledPlayer.setRawXP(n, false);
            } else {
                skilledPlayer.setXP(amountChangeFactory.getType() == AmountChangeFactory.Type.REMOVE ? -amountChangeFactory.getAmount() : (double)n);
            }
            return true;
        });
    }

    @Override
    public String[] tabComplete(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            return AmountChangeFactory.tabComplete(stringArray[1]);
        }
        if (stringArray.length == 3) {
            return new String[]{"<amount>"};
        }
        if (stringArray.length == 4) {
            return new String[]{"<raw>"};
        }
        return new String[0];
    }
}

