/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.party.PartyRank;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandUserReset
extends SkillsCommand {
    public CommandUserReset(SkillsCommand skillsCommand) {
        super("reset", skillsCommand, SkillsLang.COMMAND_USER_RESET_DESCRIPTION, false, "resetplayer", "playerreset", "resetinfo", "inforeset");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)stringArray[0]);
            if (offlinePlayer != null) {
                SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(offlinePlayer.getUniqueId());
                if (skilledPlayer.getRank() == PartyRank.LEADER) {
                    skilledPlayer.getParty().disband();
                }
                this.plugin.getPlayerDataManager().delete(offlinePlayer.getUniqueId());
                SkillsLang.COMMAND_USER_RESET_SUCCESS.sendMessage(commandSender, "%player%", offlinePlayer.getName());
            } else {
                SkillsLang.PLAYER_NOT_FOUND.sendMessage(commandSender, "%name%", stringArray[0]);
            }
        } else {
            SkillsCommandHandler.sendUsage(commandSender, "user reset <player>");
        }
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        return stringArray.length > 1 ? new String[]{} : null;
    }
}

