/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.TabCompleteManager;
import org.skills.commands.user.AmountChangeFactory;
import org.skills.commands.user.CommandUser;
import org.skills.main.locale.SkillsLang;
import org.skills.masteries.managers.Mastery;
import org.skills.masteries.managers.MasteryManager;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandUserMastery
extends SkillsCommand {
    public CommandUserMastery(SkillsCommand skillsCommand) {
        super("mastery", skillsCommand, SkillsLang.COMMAND_USER_MASTERY_DESCRIPTION, false, "masteries");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        CommandUser.handle(this, commandSender, stringArray, "mastery", (amountChangeFactory, offlinePlayer, skilledPlayer, string, bl) -> {
            Mastery mastery = MasteryManager.getMastery(string);
            if (mastery == null) {
                SkillsLang.MASTERY_NOT_FOUND.sendMessage(commandSender, "%mastery%", string);
                return false;
            }
            int n = (int)amountChangeFactory.withInitialAmount(skilledPlayer.getMasteryLevel(mastery)).getFinalAmount();
            skilledPlayer.setMasteryLevel(mastery, n);
            return true;
        });
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            return AmountChangeFactory.tabComplete(stringArray[1]);
        }
        if (stringArray.length == 3) {
            return TabCompleteManager.getMasteries(stringArray[2]);
        }
        if (stringArray.length == 4) {
            return new String[]{"<amount>"};
        }
        return new String[0];
    }
}

