/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.user.AmountChangeFactory;
import org.skills.commands.user.CommandUser;
import org.skills.data.managers.PlayerDataManager;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.LevelUp;
import org.skills.types.SkillScaling;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandUserLevel
extends SkillsCommand {
    public CommandUserLevel(SkillsCommand skillsCommand) {
        super("level", skillsCommand, SkillsLang.COMMAND_USER_LEVEL_DESCRIPTION, false, "lvl", "lvls", "levels");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        CommandUser.handle(this, commandSender, stringArray, (amountChangeFactory, offlinePlayer, skilledPlayer, bl) -> {
            int n;
            int n2 = skilledPlayer.getLevel();
            int n3 = (int)amountChangeFactory.withInitialAmount(n2).getFinalAmount();
            if (n3 >= (n = (int)skilledPlayer.getScaling(SkillScaling.MAX_LEVEL))) {
                n3 = n;
                if (!bl && offlinePlayer.isOnline()) {
                    SkillsLang.MAX_LEVEL.sendMessage((Player)offlinePlayer, new Object[0]);
                }
            }
            skilledPlayer.setLevel(n3);
            if (skilledPlayer.getXP() > skilledPlayer.getLevelXP()) {
                skilledPlayer.setAbsoluteXP(0.0);
            }
            if (!bl && n3 > n2) {
                this.handleLevelup(skilledPlayer, offlinePlayer);
            }
            PlayerDataManager.addLevel(offlinePlayer, n3);
            return true;
        });
    }

    public void handleLevelup(SkilledPlayer skilledPlayer, OfflinePlayer offlinePlayer) {
        int n = skilledPlayer.getLevel();
        LevelUp levelUp = null;
        for (int i = 0; i < n; ++i) {
            LevelUp levelUp2 = LevelUp.getProperties(i).forPlayer(offlinePlayer).evaluateRewards();
            if (levelUp == null) {
                levelUp = levelUp2;
                continue;
            }
            levelUp.add(levelUp2);
        }
        if (levelUp != null && offlinePlayer.isOnline()) {
            levelUp.level(n);
            if (SkillsConfig.LEVEL_CELEBRATION.getBoolean()) {
                levelUp.celebrate((Player)offlinePlayer, this.plugin);
            }
            levelUp.performRewards().performMessages();
        }
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            return AmountChangeFactory.tabComplete(stringArray[1]);
        }
        if (stringArray.length == 3) {
            return new String[]{"<amount>", "[silent]"};
        }
        if (stringArray.length == 4) {
            return new String[]{"silent"};
        }
        return new String[0];
    }
}

