/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.skills.abilities.Ability;
import org.skills.commands.SkillsCommand;
import org.skills.commands.user.AmountChangeFactory;
import org.skills.commands.user.CommandUser;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;

public class CommandUserImprove
extends SkillsCommand {
    public CommandUserImprove(SkillsCommand skillsCommand) {
        super("improve", skillsCommand, SkillsLang.COMMAND_USER_IMPROVE_DESCRIPTION, false, "improvement", "improvements", "upgrade", "upgrades", "ability", "abilities");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        CommandUser.handle(this, commandSender, stringArray, "ability", (amountChangeFactory, offlinePlayer, skilledPlayer, string, bl) -> {
            Ability ability = skilledPlayer.getSkill().getAbility(string);
            if (ability == null) {
                SkillsLang.ABILITY_NOT_FOUND.sendMessage(commandSender, "%ability%", string, "%player%", offlinePlayer.getName());
                return false;
            }
            int n = (int)amountChangeFactory.withInitialAmount(skilledPlayer.getAbilityLevel(ability)).getFinalAmount();
            if (amountChangeFactory.getType() == AmountChangeFactory.Type.SET && (n < 0 || n > 3)) {
                SkillsLang.ABILITY_INVALID_LEVEL.sendMessage(commandSender, new Object[0]);
                return false;
            }
            skilledPlayer.setAbilityLevel(ability, Math.max(0, Math.min(3, n)));
            return true;
        });
    }

    @Override
    public String[] tabComplete(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            return AmountChangeFactory.tabComplete(stringArray[1]);
        }
        if (stringArray.length == 3) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)stringArray[0]);
            if (offlinePlayer == null || !offlinePlayer.hasPlayedBefore()) {
                return new String[0];
            }
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(offlinePlayer);
            if (skilledPlayer == null) {
                return new String[0];
            }
            return (String[])skilledPlayer.getSkill().getAbilities().stream().map(Ability::getName).filter(string -> string.startsWith(stringArray[2])).toArray(String[]::new);
        }
        if (stringArray.length == 4) {
            return new String[]{"<amount>"};
        }
        return new String[0];
    }
}

