/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.user.AmountChangeFactory;
import org.skills.commands.user.CommandUser;
import org.skills.main.locale.SkillsLang;

public class CommandUserEnergy
extends SkillsCommand {
    public CommandUserEnergy(SkillsCommand skillsCommand) {
        super("energy", skillsCommand, SkillsLang.COMMAND_USER_ENERGY_DESCRIPTION, false, new String[0]);
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        CommandUser.handle(this, commandSender, stringArray, (amountChangeFactory, offlinePlayer, skilledPlayer, bl) -> {
            double d = skilledPlayer.getEnergy();
            int n = (int)amountChangeFactory.withInitialAmount(d).getFinalAmount();
            if (bl) {
                skilledPlayer.setEnergy(n);
            } else {
                skilledPlayer.setEnergy(amountChangeFactory.getType() == AmountChangeFactory.Type.REMOVE ? d - amountChangeFactory.getAmount() : (double)n);
            }
            return true;
        });
    }

    @Override
    public String[] tabComplete(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            return AmountChangeFactory.tabComplete(stringArray[1]);
        }
        if (stringArray.length == 3) {
            return new String[]{"<amount>"};
        }
        if (stringArray.length == 4) {
            return new String[]{"<raw>"};
        }
        return new String[0];
    }
}

