/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.data.managers.Cosmetic;
import org.skills.data.managers.CosmeticCategory;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandUserCosmetic
extends SkillsCommand {
    public CommandUserCosmetic(SkillsCommand skillsCommand) {
        super("cosmetic", skillsCommand, SkillsLang.COMMAND_USER_COSMETIC_DESCRIPTION, false, "cosmetics", "cos");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length < 3) {
            SkillsCommandHandler.sendUsage(commandSender, "user cosmetic <player> <category> <cosmetic>");
            return;
        }
        String string = stringArray[0];
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)string);
        if (!offlinePlayer.hasPlayedBefore()) {
            SkillsLang.PLAYER_NOT_FOUND.sendMessage(commandSender, "%name%", stringArray[0]);
            return;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(offlinePlayer);
        CosmeticCategory cosmeticCategory = CosmeticCategory.get(stringArray[1]);
        if (cosmeticCategory == null) {
            SkillsLang.COMMAND_USER_COSMETIC_INVALID_CATEGORY.sendMessage(commandSender, "%category%", stringArray[1], "%cosmetic%", stringArray[2]);
            return;
        }
        Cosmetic cosmetic = cosmeticCategory.getCosmetic(stringArray[2]);
        if (cosmetic == null) {
            SkillsLang.COMMAND_USER_COSMETIC_INVALID_COSMETIC.sendMessage(commandSender, "%category%", stringArray[1], "%cosmetic%", stringArray[2]);
            return;
        }
        if (skilledPlayer.getCosmetic(cosmeticCategory.getName()) == cosmetic) {
            SkillsLang.COMMAND_USER_COSMETIC_ALREADY_SET.sendMessage(commandSender, "%category%", stringArray[1], "%cosmetic%", stringArray[2]);
            return;
        }
        skilledPlayer.setCosmetic(cosmetic);
        SkillsLang.COMMAND_USER_COSMETIC_SET.sendMessage(commandSender, "%category%", stringArray[1], "%cosmetic%", stringArray[2]);
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            ArrayList<String> arrayList = new ArrayList<String>(CosmeticCategory.getCategories().keySet());
            return (String[])arrayList.stream().filter(string -> string.toLowerCase().startsWith(stringArray[1].toLowerCase())).toArray(String[]::new);
        }
        if (stringArray.length == 3) {
            CosmeticCategory cosmeticCategory = CosmeticCategory.get(stringArray[1]);
            if (cosmeticCategory == null) {
                return new String[0];
            }
            return cosmeticCategory.getCosmetics().keySet().toArray(new String[0]);
        }
        return new String[0];
    }
}

