/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.skills.abilities.AbilityManager;
import org.skills.commands.SkillsCommand;
import org.skills.commands.user.AmountChangeFactory;
import org.skills.commands.user.CommandUser;
import org.skills.main.locale.SkillsLang;

public class CommandUserCooldown
extends SkillsCommand {
    public CommandUserCooldown(SkillsCommand skillsCommand) {
        super("cooldown", skillsCommand, SkillsLang.COMMAND_USER_COOLDOWN_DESCRIPTION, false, new String[0]);
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            OfflinePlayer offlinePlayer2 = Bukkit.getOfflinePlayer((String)stringArray[0]);
            if (!offlinePlayer2.hasPlayedBefore()) {
                SkillsLang.PLAYER_NOT_FOUND.sendMessage(commandSender, "%name%", stringArray[0]);
                return;
            }
            if (AbilityManager.getCooldownExcempts().remove(offlinePlayer2.getUniqueId())) {
                SkillsLang.COMMAND_USER_COOLDOWN_DISABLED.sendMessage(commandSender, "%name%", stringArray[0]);
            } else {
                SkillsLang.COMMAND_USER_COOLDOWN_ENABLED.sendMessage(commandSender, "%name%", stringArray[0]);
                AbilityManager.getCooldownExcempts().add(offlinePlayer2.getUniqueId());
            }
            return;
        }
        CommandUser.handle(this, commandSender, stringArray, (amountChangeFactory, offlinePlayer, skilledPlayer, bl) -> {
            double d = skilledPlayer.getCooldownTimeLeft();
            int n = (int)amountChangeFactory.withInitialAmount(d).getFinalAmount();
            if (bl) {
                skilledPlayer.setCooldown(n);
            } else {
                long l = (long)(d - amountChangeFactory.getAmount());
                if (l < 0L) {
                    skilledPlayer.setCooldown(0L);
                }
                skilledPlayer.setCooldown(amountChangeFactory.getType() == AmountChangeFactory.Type.REMOVE ? l : (long)n);
            }
            return true;
        });
    }

    @Override
    public String[] tabComplete(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            return AmountChangeFactory.tabComplete(stringArray[1]);
        }
        if (stringArray.length == 3) {
            return new String[]{"<amount in ms>"};
        }
        if (stringArray.length == 4) {
            return new String[]{"<raw>"};
        }
        return new String[0];
    }
}

