/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.commands.TabCompleteManager;
import org.skills.commands.user.AmountChangeFactory;
import org.skills.commands.user.CommandUserCooldown;
import org.skills.commands.user.CommandUserCosmetic;
import org.skills.commands.user.CommandUserEnergy;
import org.skills.commands.user.CommandUserImprove;
import org.skills.commands.user.CommandUserLevel;
import org.skills.commands.user.CommandUserMastery;
import org.skills.commands.user.CommandUserReset;
import org.skills.commands.user.CommandUserSkill;
import org.skills.commands.user.CommandUserSouls;
import org.skills.commands.user.CommandUserStats;
import org.skills.commands.user.CommandUserVulnerable;
import org.skills.commands.user.CommandUserXP;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.HealthAndEnergyManager;
import org.skills.types.SkillScaling;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.Particles;

public class CommandUser
extends SkillsCommand {
    public CommandUser() {
        super("user", SkillsLang.COMMAND_USER_DESCRIPTION, true, "playerinfo");
        new CommandUserXP(this);
        new CommandUserLevel(this);
        new CommandUserEnergy(this);
        new CommandUserCooldown(this);
        new CommandUserSouls(this);
        new CommandUserSkill(this);
        new CommandUserStats(this);
        new CommandUserReset(this);
        new CommandUserMastery(this);
        new CommandUserImprove(this);
        new CommandUserCosmetic(this);
        new CommandUserVulnerable(this);
    }

    public static void magicCircle(int n, double d, ParticleDisplay particleDisplay) {
        if (n == 1) {
            Particles.polygon(4, 4, d, 0.02, 0.3, particleDisplay);
            Particles.polygon(4, 3, d / (d - 1.0), 0.5, 0.0, particleDisplay.clone().rotate(0.0, 1.5707963267948966, 0.0));
            Particles.polygon(8, 3, d / (d - 1.0), 0.5, 0.0, particleDisplay);
            Particles.polygon(8, 3, d / (d - 1.0), 0.5, 0.0, particleDisplay);
        } else if (n == 2) {
            Particles.polygon(3, 3, d / (d - 1.0), 0.5, 0.0, particleDisplay);
            Particles.polygon(6, 3, d / (d - 1.0), 0.5, 0.0, particleDisplay);
        } else if (n != 3 && n == 4) {
            Particles.polygon(8, 3, d / (d - 1.0), 0.5, 0.0, particleDisplay);
            Particles.circle(d, d * 5.0, particleDisplay);
        }
        Particles.circle(d, d * 10.0, particleDisplay);
    }

    public static void handle(SkillsCommand skillsCommand, @NotNull CommandSender commandSender, @NotNull String[] stringArray, UserAmountHandler userAmountHandler) {
        CommandUser.handle(skillsCommand, commandSender, stringArray, null, (amountChangeFactory, offlinePlayer, skilledPlayer, string, bl) -> userAmountHandler.handle(amountChangeFactory, offlinePlayer, skilledPlayer, bl));
    }

    public static void handle(SkillsCommand skillsCommand, @NotNull CommandSender commandSender, @NotNull String[] stringArray, String string, TypedUserAmountHandler typedUserAmountHandler) {
        List<OfflinePlayer> list;
        boolean bl = string != null;
        if (stringArray.length < (bl ? 4 : 3)) {
            String string2 = bl ? "" : " <" + string + '>';
            SkillsCommandHandler.sendUsage(commandSender, "user " + skillsCommand.getName() + " <player> <add/decrease/set>" + string2 + " <amount>");
            return;
        }
        if (stringArray[0].equals("*")) {
            list = Bukkit.getOnlinePlayers();
        } else {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)stringArray[0]);
            if (!offlinePlayer.hasPlayedBefore()) {
                SkillsLang.PLAYER_NOT_FOUND.sendMessage(commandSender, "%name%", stringArray[0]);
                return;
            }
            list = Collections.singletonList(offlinePlayer);
        }
        int n = bl ? 4 : 3;
        boolean bl2 = stringArray.length > n + 1 && stringArray[n].equalsIgnoreCase("silent");
        AmountChangeFactory amountChangeFactory = AmountChangeFactory.of(commandSender, 1, bl ? 3 : 2, stringArray);
        if (amountChangeFactory == null) {
            return;
        }
        String string3 = null;
        if (bl) {
            string3 = stringArray[2];
        }
        for (OfflinePlayer offlinePlayer : list) {
            SkilledPlayer skilledPlayer;
            if (!typedUserAmountHandler.handle(amountChangeFactory, offlinePlayer, skilledPlayer = SkilledPlayer.getSkilledPlayer(offlinePlayer), string3, bl2)) continue;
            amountChangeFactory.handleSuccess(commandSender, "COMMAND_USER_" + skillsCommand.getName().toUpperCase(), offlinePlayer);
            if (!offlinePlayer.isOnline()) continue;
            double d = skilledPlayer.getScaling(SkillScaling.MAX_ENERGY);
            if (skilledPlayer.getEnergy() > d) {
                skilledPlayer.setEnergy(d);
            }
            HealthAndEnergyManager.updateStats(offlinePlayer.getPlayer());
        }
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        SkillsCommandHandler.executeHelperForGroup(this, commandSender);
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        return stringArray.length < 2 ? TabCompleteManager.getSubCommand(commandSender, this, stringArray).toArray(new String[0]) : new String[]{};
    }

    @FunctionalInterface
    protected static interface UserAmountHandler {
        public boolean handle(AmountChangeFactory var1, OfflinePlayer var2, SkilledPlayer var3, boolean var4);
    }

    @FunctionalInterface
    protected static interface TypedUserAmountHandler {
        public boolean handle(AmountChangeFactory var1, OfflinePlayer var2, SkilledPlayer var3, String var4, boolean var5);
    }
}

