/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import java.util.Arrays;
import java.util.Locale;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.skills.main.locale.SkillsLang;

public final class AmountChangeFactory {
    private final Type type;
    private final double amount;
    private double initialAmount;

    public AmountChangeFactory(Type type, double d) {
        this.type = type;
        this.amount = d;
    }

    public static AmountChangeFactory of(CommandSender commandSender, int n, int n2, String[] stringArray) {
        double d;
        Type type = AmountChangeFactory.getType(stringArray[n]);
        if (type == null) {
            SkillsLang.Command_User_Invalid_Setter.sendMessage(commandSender, "%setter%", stringArray[n]);
            return null;
        }
        String string = stringArray[n2];
        try {
            d = Double.parseDouble(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SkillsLang.NOT_NUMBER.sendMessage(commandSender, "%arg%", string);
            return null;
        }
        if (d < 0.0) {
            if (type == Type.ADD) {
                type = Type.REMOVE;
            }
            d = -d;
        }
        return new AmountChangeFactory(type, d);
    }

    protected static Type getType(String string) {
        switch (string.toLowerCase(Locale.ENGLISH)) {
            case "add": 
            case "increase": {
                return Type.ADD;
            }
            case "remove": 
            case "decrease": {
                return Type.REMOVE;
            }
            case "set": {
                return Type.SET;
            }
        }
        return null;
    }

    protected static String[] tabComplete(String string) {
        String[] stringArray = new String[]{"add", "decrease", "set"};
        if (string.isEmpty()) {
            return stringArray;
        }
        String string3 = string.toLowerCase(Locale.ENGLISH);
        return (String[])Arrays.stream(stringArray).filter(string2 -> string2.startsWith(string3)).toArray(String[]::new);
    }

    public double getAmount() {
        return this.amount;
    }

    public Type getType() {
        return this.type;
    }

    public AmountChangeFactory withInitialAmount(double d) {
        this.initialAmount = d;
        return this;
    }

    public double getFinalAmount() {
        switch (this.type.ordinal()) {
            case 0: {
                return this.initialAmount + this.amount;
            }
            case 1: {
                return this.initialAmount - this.amount;
            }
            case 2: {
                return this.amount;
            }
        }
        throw new AssertionError((Object)("Unknown setter type: " + (Object)((Object)this.type)));
    }

    public void handleSuccess(CommandSender commandSender, String string, OfflinePlayer offlinePlayer) {
        SkillsLang skillsLang = SkillsLang.valueOf(string + '_' + this.type.name());
        skillsLang.sendMessage(commandSender, "%player%", offlinePlayer.getName(), "%amount%", this.amount, "%new%", this.getFinalAmount());
    }

    public static enum Type {
        ADD,
        REMOVE,
        SET;

    }
}

