/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.party;

import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.gui.GUIOption;
import org.skills.gui.GUIParser;
import org.skills.gui.InteractiveGUI;
import org.skills.main.SLogger;
import org.skills.main.SkillsPro;
import org.skills.main.locale.SkillsLang;
import org.skills.party.SkillsParty;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.xseries.profiles.builder.XSkull;
import org.skills.utils.xseries.profiles.objects.Profileable;

public class CommandPartyParties
extends SkillsCommand {
    public CommandPartyParties(SkillsCommand skillsCommand) {
        super("parties", skillsCommand, SkillsLang.COMMAND_PARTY_LIST_DESCRIPTION, new String[0]);
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
            return;
        }
        Player player = (Player)commandSender;
        InteractiveGUI interactiveGUI = GUIParser.parseOption(player, "parties");
        if (interactiveGUI == null) {
            SLogger.error("Could not find parties GUI.");
        }
        GUIOption gUIOption = interactiveGUI.getHolder("party", new Object[0]);
        List<Integer> list = gUIOption.getSlots();
        for (SkillsParty skillsParty : SkillsPro.get().getPartyManager().getAllData()) {
            GUIOption gUIOption2 = gUIOption.clone();
            ItemStack itemStack = XSkull.of(gUIOption2.getItem()).profile(Profileable.of(skillsParty.getLeader())).apply();
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)skillsParty.getLeader());
            GUIOption.defineVariables(itemStack, offlinePlayer, new Object[0]);
            interactiveGUI.push(gUIOption2, itemStack, (int)list.remove(0), () -> {}, "%party%", skillsParty.getName(), "%leader%", offlinePlayer.getName());
        }
        interactiveGUI.dispose("party");
        interactiveGUI.setRest();
        interactiveGUI.openInventory(player);
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        return new String[0];
    }
}

