/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.party;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.data.managers.SkilledPlayer;
import org.skills.gui.GUIOption;
import org.skills.gui.GUIParser;
import org.skills.gui.InteractiveGUI;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.party.PartyRank;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.xseries.profiles.builder.XSkull;
import org.skills.utils.xseries.profiles.objects.Profileable;

public class CommandPartyList
extends SkillsCommand {
    public CommandPartyList(SkillsCommand skillsCommand) {
        super("list", skillsCommand, SkillsLang.COMMAND_PARTY_LIST_DESCRIPTION, "members");
    }

    public static void openMember(Player player, OfflinePlayer offlinePlayer) {
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(offlinePlayer);
        InteractiveGUI interactiveGUI = GUIParser.parseOption(player, (OfflinePlayer)player, "party-member", "%name%", offlinePlayer.getName(), "%online%", MessageHandler.colorize(offlinePlayer.isOnline() ? "&2Online" : "&cOffline"), "%mod%", skilledPlayer.getRank() == PartyRank.MODERATOR);
        if (interactiveGUI == null) {
            return;
        }
        SkilledPlayer skilledPlayer2 = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        interactiveGUI.push("mod", () -> {
            if (skilledPlayer2.getRank() != PartyRank.LEADER) {
                SkillsLang.COMMAND_PARTY_MOD_PERMISSION.sendMessage(player, new Object[0]);
                return;
            }
            if (skilledPlayer.getRank() == PartyRank.MEMBER) {
                skilledPlayer.setRank(PartyRank.MODERATOR);
                for (Player player2 : skilledPlayer2.getParty().getOnlineMembers()) {
                    SkillsLang.COMMAND_PARTY_MOD_PROMOTED.sendMessage(player2, "%mod%", player.getName());
                }
            } else {
                skilledPlayer.setRank(PartyRank.MEMBER);
                for (Player player3 : skilledPlayer2.getParty().getOnlineMembers()) {
                    SkillsLang.COMMAND_PARTY_MOD_DEMOTED.sendMessage(player3, "%mod%", player.getName());
                }
            }
        }, new Object[0]).push("kick", () -> {
            if (skilledPlayer2.getRank() == PartyRank.MEMBER) {
                SkillsLang.COMMAND_PARTY_KICK_PERMISSION.sendMessage(player, new Object[0]);
                return;
            }
            if (player.getUniqueId().equals(offlinePlayer.getUniqueId())) {
                SkillsLang.COMMAND_PARTY_KICK_SELF.sendMessage(player, new Object[0]);
                return;
            }
            for (OfflinePlayer offlinePlayer2 : skilledPlayer2.getParty().getOnlineMembers()) {
                if (!offlinePlayer2.isOnline()) continue;
                SkillsLang.COMMAND_PARTY_KICK_KICKED.sendMessage((Player)offlinePlayer2, (OfflinePlayer)player, new Object[]{"%kicked%", player.getName(), "%kicker%", player.getName()});
            }
            skilledPlayer2.leaveParty();
        }, new Object[0]);
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
            return;
        }
        final Player player = (Player)commandSender;
        final SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (!skilledPlayer.hasParty()) {
            SkillsLang.NO_PARTY.sendMessage(player, new Object[0]);
            return;
        }
        final InteractiveGUI interactiveGUI = GUIParser.parseOption(player, "party");
        final List<Integer> list = interactiveGUI.getHolder("member", new Object[0]).getSlots();
        new BukkitRunnable(){

            public void run() {
                for (OfflinePlayer offlinePlayer : skilledPlayer.getParty().getPlayerMembers()) {
                    GUIOption gUIOption = interactiveGUI.getHolder("member", new Object[0]);
                    ItemStack itemStack = XSkull.of(gUIOption.getItem()).profile(Profileable.of(offlinePlayer)).apply();
                    GUIOption.defineVariables(itemStack, offlinePlayer, new Object[0]);
                    int n = (Integer)list.remove(0);
                    interactiveGUI.push(gUIOption, itemStack, n, () -> CommandPartyList.openMember(player, offlinePlayer), "%name%", offlinePlayer.getName(), "%online%", MessageHandler.colorize(offlinePlayer.isOnline() ? "&2Online" : "&cOffline"));
                }
                interactiveGUI.dispose("member");
                interactiveGUI.setRest();
                interactiveGUI.openInventory(player);
            }
        }.runTaskAsynchronously((Plugin)SkillsPro.get());
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        return new String[0];
    }
}

