/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.party;

import java.util.concurrent.TimeUnit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.party.PartyRank;
import org.skills.party.SkillsParty;
import org.skills.utils.Cooldown;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandPartyLeave
extends SkillsCommand {
    public CommandPartyLeave(SkillsCommand skillsCommand) {
        super("leave", skillsCommand, SkillsLang.COMMAND_PARTY_LEAVE_DESCRIPTION, new String[0]);
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
            return;
        }
        Player player = (Player)commandSender;
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (!skilledPlayer.hasParty()) {
            SkillsLang.NO_PARTY.sendMessage(player, new Object[0]);
            return;
        }
        SkillsParty skillsParty = skilledPlayer.getParty();
        if (skilledPlayer.getRank() == PartyRank.LEADER) {
            if (Cooldown.isInCooldown(player.getUniqueId(), "PARTY_DISBAND")) {
                for (Player player2 : skillsParty.getOnlineMembers()) {
                    SkillsLang.COMMAND_PARTY_LEAVE_DISBANDED.sendMessage(player2, "%party%", skillsParty.getName());
                }
                skillsParty.disband();
            } else {
                new Cooldown(player.getUniqueId(), "PARTY_DISBAND", 30L, TimeUnit.SECONDS);
                SkillsLang.COMMAND_PARTY_LEAVE_DISBAND_CONFIRM.sendMessage(player, new Object[0]);
            }
            return;
        }
        for (Player player3 : skillsParty.getOnlineMembers()) {
            SkillsLang.COMMAND_PARTY_LEAVE_LEFT.sendMessage(player3, (OfflinePlayer)player, new Object[0]);
        }
        skilledPlayer.leaveParty();
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        return new String[0];
    }
}

