/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.general;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.skills.commands.SkillsCommand;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.HoverLang;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.MathUtils;
import org.skills.utils.StringUtils;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

public class CommandStatistics
extends SkillsCommand {
    public CommandStatistics() {
        super("statistics", null, SkillsLang.COMMAND_STATISTICS_DESCRIPTION, false, "statistic", "percents");
    }

    private static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> arrayList = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        arrayList.sort(Collections.reverseOrder(Map.Entry.comparingByValue()));
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : arrayList) {
            linkedHashMap.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return linkedHashMap;
    }

    public static String padRight(String string, int n) {
        return String.format("%-" + n + 's', string);
    }

    public static String padLeft(String string, int n) {
        return String.format("%" + n + 's', string);
    }

    @Override
    public void runCommand(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        CompletableFuture.runAsync(() -> {
            MessageHandler.sendMessage(commandSender, "&3Loading players data. This can take a few seconds...");
            Map<String, Integer> map = new HashMap();
            int n = 0;
            for (Object object : this.plugin.getPlayerDataManager().getAllData()) {
                Objects.requireNonNull(((SkilledPlayer)object).getSkill(), () -> CommandStatistics.lambda$runCommand$0((SkilledPlayer)object));
                String object2 = ((SkilledPlayer)object).getSkill().getDisplayName();
                Objects.requireNonNull(object2, () -> CommandStatistics.lambda$runCommand$1((SkilledPlayer)object));
                map.put(object2, map.getOrDefault(object2, 0) + 1);
                ++n;
            }
            int n2 = 100;
            MessageHandler.sendMessage(commandSender, "&3Loaded &e" + n + " &3player data.");
            map = CommandStatistics.sortByValue(map);
            for (Map.Entry entry : map.entrySet()) {
                double d = MathUtils.getPercent(((Integer)entry.getValue()).intValue(), n);
                int n3 = (int)Math.floor(MathUtils.getAmountFromAmount(d, 100.0, n2));
                int n4 = n2 - n3;
                String string = "&2" + Strings.repeat((String)"|", (int)n3) + (n4 != 0 ? "&8" + Strings.repeat((String)"|", (int)n4) : "");
                d = MathUtils.roundToDigits(d, 3);
                HoverLang.sendComplexMessage(commandSender, null, "COMPLEX:&3" + (String)entry.getKey() + "&8: hover:{" + string + ",&e" + d + "%} &8(&7" + StringUtils.toFancyNumber(((Integer)entry.getValue()).intValue()) + "&8)", new Object[0]);
            }
        }).exceptionally(throwable -> {
            throwable.printStackTrace();
            return null;
        });
    }

    @Override
    public @Nullable String[] tabComplete(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        return new String[0];
    }

    private static /* synthetic */ String lambda$runCommand$1(SkilledPlayer skilledPlayer) {
        return "Player skill displayname cannot be null while handling statistics for: " + skilledPlayer.getOfflinePlayer().getName();
    }

    private static /* synthetic */ String lambda$runCommand$0(SkilledPlayer skilledPlayer) {
        return "Player skill cannot be null while handling statistics for: " + skilledPlayer.getOfflinePlayer().getName();
    }
}

