/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.general;

import java.util.Locale;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.SkillsLang;
import org.skills.services.ServiceVault;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandSouls
extends SkillsCommand {
    public CommandSouls() {
        super("souls", SkillsLang.COMMAND_SOULS_DESCRIPTION, "soulbank");
    }

    @Override
    public void runCommand(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        int n;
        if (!ServiceHandler.isAvailable("Vault")) {
            SkillsLang.COMMAND_SOULS_SERVICE_UNAVAILABLE.sendMessage(commandSender, new Object[0]);
            return;
        }
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
            return;
        }
        if (stringArray.length < 2) {
            SkillsCommandHandler.sendUsage(commandSender, "<deposit/withdraw> <amount>");
            return;
        }
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            SkillsLang.Command_Not_Number.sendMessage(commandSender, "%arg%", stringArray[1], "%needed%", "souls");
            return;
        }
        if (n <= 0) {
            SkillsLang.COMMAND_AT_LEAST_ONE.sendMessage(commandSender, "%arg%", stringArray[1], "%needed%", "souls");
            return;
        }
        Player player = (Player)commandSender;
        String string = stringArray[0].toLowerCase(Locale.ENGLISH);
        if (string.equalsIgnoreCase("deposit")) {
            if (!SkillsConfig.ECONOMY_DEPOSIT_ENABLED.getBoolean()) {
                SkillsLang.COMMAND_SOULS_DEPOSIT_DISABLED.sendMessage(player, new Object[0]);
                return;
            }
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
            if (skilledPlayer.getSouls() < (long)n) {
                SkillsLang.COMMAND_SOULS_NOT_ENOUGH_SOULS.sendMessage(player, "%amount%", n);
                return;
            }
            skilledPlayer.addSouls(-n);
            double d = (double)n * SkillsConfig.ECONOMY_DEPOSIT_SOUL_WORTH.getDouble();
            ServiceVault.deposit((OfflinePlayer)player, d);
            SkillsLang.COMMAND_SOULS_DEPOSIT_SUCCESS.sendMessage(player, "%amount%", n, "%translated%", d, "%balance%", ServiceVault.getMoney((OfflinePlayer)player));
        } else if (string.equalsIgnoreCase("withdraw")) {
            if (!SkillsConfig.ECONOMY_WITHDRAW_ENABLED.getBoolean()) {
                SkillsLang.COMMAND_SOULS_WITHDRAW_DISABLED.sendMessage(player, new Object[0]);
                return;
            }
            double d = (double)n * SkillsConfig.ECONOMY_WITHDRAW_SOUL_WORTH.getDouble();
            if (!ServiceVault.hasMoney((OfflinePlayer)player, d)) {
                SkillsLang.COMMAND_SOULS_NOT_ENOUGH_MONEY.sendMessage(player, "%amount%", n);
                return;
            }
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
            skilledPlayer.addSouls(n);
            ServiceVault.withdraw((OfflinePlayer)player, d);
            SkillsLang.COMMAND_SOULS_WITHDRAW_SUCCESS.sendMessage(player, "%amount%", n, "%translated%", d, "%balance%", ServiceVault.getMoney((OfflinePlayer)player));
        } else {
            SkillsLang.COMMAND_SOULS_UNKNOWN_TRANSACTION.sendMessage(player, "%transaction%", stringArray[0]);
        }
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        if (commandSender instanceof Player) {
            if (stringArray.length == 1) {
                return new String[]{"deposit", "withdraw"};
            }
            if (stringArray.length == 2) {
                return new String[]{"<amount>"};
            }
        }
        return new String[0];
    }
}

