/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.general;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.skills.commands.SkillsCommand;
import org.skills.commands.TabCompleteManager;
import org.skills.data.managers.SkilledPlayer;
import org.skills.gui.GUIParser;
import org.skills.gui.InteractiveGUI;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.MathUtils;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.nbt.ItemNBT;
import org.skills.utils.xseries.XSound;

public class CommandShop
extends SkillsCommand {
    public CommandShop() {
        super("shop", SkillsLang.COMMAND_SHOP_DESCRIPTION, "magic", "magicshop");
    }

    @Override
    public void runCommand(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendMessage(commandSender, new Object[0]);
            return;
        }
        Player player = (Player)commandSender;
        if (stringArray.length > 0 && stringArray[0].equalsIgnoreCase("give")) {
            int n;
            Player player2;
            block13: {
                if (player.hasPermission("skills.command.shop.give")) {
                    SkillsLang.COMMAND_SHOP_GIVE_PERMISSION.sendMessage(player, new Object[0]);
                    return;
                }
                if (stringArray.length < 2) {
                    SkillsLang.COMMAND_SHOP_GIVE_USAGE.sendMessage(player, new Object[0]);
                    return;
                }
                player2 = null;
                n = 1;
                try {
                    n = Integer.parseInt(stringArray[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    player2 = Bukkit.getPlayer((String)stringArray[2]);
                    if (player2 != null) break block13;
                    SkillsLang.COMMAND_SHOP_GIVE_USAGE.sendMessage(player, new Object[0]);
                    return;
                }
            }
            if (player2 == null && stringArray.length > 3) {
                player2 = Bukkit.getPlayer((String)stringArray[2]);
                if (player2 == null) {
                    SkillsLang.PLAYER_NOT_FOUND.sendMessage(player, new Object[0]);
                    return;
                }
            } else {
                player2 = player;
            }
            String string = stringArray[1];
            ConfigurationSection configurationSection = this.plugin.getConfig().getConfigurationSection("skills-items." + string);
            if (configurationSection == null) {
                SkillsLang.COMMAND_SHOP_GIVE_INVALID_TYPE.sendMessage(player, "%type%", stringArray[1]);
                return;
            }
            ItemStack itemStack = GUIParser.deserializeItem("Failed to parse skill item: " + string, configurationSection);
            itemStack.setAmount(n);
            itemStack = ItemNBT.addSimpleTag(itemStack, "Skill_Item", configurationSection.getString("skills-item-type"));
            if (player2.getInventory().firstEmpty() > -1) {
                player2.getInventory().addItem(new ItemStack[]{itemStack});
            } else {
                player2.getWorld().dropItemNaturally(player2.getLocation(), itemStack);
            }
            return;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        InteractiveGUI interactiveGUI = GUIParser.parseOption(player, "shop");
        for (String string : interactiveGUI.getHolders()) {
            if (!string.startsWith("sell")) continue;
            interactiveGUI.push(string, () -> {
                ConfigurationSection configurationSection = interactiveGUI.getOptionsSection().getConfigurationSection(string);
                String string2 = configurationSection.getString("skills-item");
                ConfigurationSection configurationSection2 = this.plugin.getConfig().getConfigurationSection("skills-items." + string2);
                if (configurationSection2 == null) {
                    MessageHandler.sendConsolePluginMessage("&4Unable to find skills item specified in &e" + string + " &4option with type&8: &e" + string2);
                    return;
                }
                String string3 = configurationSection2.getString("cost");
                int n = (int)MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders((OfflinePlayer)player, string3));
                if (skilledPlayer.getSouls() < (long)n) {
                    SkillsLang.SKILLS_ITEM_COST.sendMessage(player, "%cost%", n);
                    XSound.BLOCK_NOTE_BLOCK_BASS.record().soundPlayer().forPlayers(player).play();
                    return;
                }
                PlayerInventory playerInventory = player.getInventory();
                int n2 = playerInventory.firstEmpty();
                if (n2 < 0) {
                    SkillsLang.SKILLS_ITEM_COST.sendMessage(player, "%cost%", n);
                    XSound.BLOCK_NOTE_BLOCK_BASS.record().soundPlayer().forPlayers(player).play();
                    return;
                }
                skilledPlayer.addSouls(-n);
                ItemStack itemStack = GUIParser.deserializeItem("Failed to parse skill item: " + string, configurationSection2);
                itemStack = ItemNBT.addSimpleTag(itemStack, "Skill_Item", configurationSection2.getString("skills-item-type"));
                playerInventory.addItem(new ItemStack[]{itemStack});
            }, new Object[0]);
        }
        interactiveGUI.setRest();
        interactiveGUI.openInventory(player);
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        if (commandSender.hasPermission("skills.command.shop.give")) {
            if (stringArray.length == 1) {
                return new String[]{"give"};
            }
            if (stringArray.length == 2) {
                return TabCompleteManager.getSuggestions(this.plugin.getConfig().getConfigurationSection("skills-items").getKeys(false).toArray(new String[0]), stringArray[1]);
            }
            if (stringArray.length == 3) {
                return null;
            }
            if (stringArray.length == 4) {
                return new String[]{"<amount>"};
            }
        }
        return new String[0];
    }
}

