/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.general;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.data.managers.CosmeticCategory;
import org.skills.gui.GUIConfig;
import org.skills.main.FileManager;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsMasteryConfig;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.HealthAndEnergyManager;
import org.skills.managers.LevelManager;
import org.skills.masteries.managers.MasteryManager;
import org.skills.types.Energy;
import org.skills.types.SkillManager;
import org.skills.types.Stat;
import org.skills.utils.Hologram;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandReload
extends SkillsCommand {
    public CommandReload() {
        super("reload", SkillsLang.COMMAND_RELOAD_DESCRIPTION, false, new String[0]);
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        FileManager.created = false;
        FileManager.isNew = false;
        FileManager fileManager = new FileManager(this.plugin);
        fileManager.createDataFolder();
        fileManager.loadConfig();
        this.plugin.reload();
        if (stringArray.length > 0 && stringArray[0].equalsIgnoreCase("config")) {
            SkillsLang.Command_Reload_Done.sendMessage(commandSender, new Object[0]);
            return;
        }
        new GUIConfig(this.plugin);
        CosmeticCategory.load(this.plugin);
        new SkillsCommandHandler(this.plugin);
        Hologram.load();
        Stat.init(this.plugin);
        Energy.init(this.plugin);
        LevelManager.load(this.plugin);
        SkillManager.init(this.plugin);
        MasteryManager.getMasteries().forEach(HandlerList::unregisterAll);
        if (SkillsMasteryConfig.MASTERIES_ENABLED.getBoolean().booleanValue()) {
            new MasteryManager();
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (SkillsConfig.isInDisabledWorld(player.getLocation())) continue;
            HealthAndEnergyManager.updateStats(player);
        }
        this.plugin.getPlayerDataManager().saveAll();
        SkillsLang.Command_Reload_Done.sendMessage(commandSender, new Object[0]);
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length > 1) {
            return new String[0];
        }
        return new String[]{"config"};
    }
}

