/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.general;

import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.main.Kingdoms;
import org.skills.commands.SkillsCommand;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;
import org.skills.utils.xseries.NoteBlockMusic;

public class CommandMusic
extends SkillsCommand {
    public CommandMusic() {
        super("music", SkillsLang.COMMAND_MUSIC_DESCRIPTION, false, "sing");
    }

    @Override
    public void runCommand(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendMessage(commandSender, new Object[0]);
            return;
        }
        if (stringArray.length == 0) {
            SkillsLang.COMMAND_MUSIC_USAGE.sendMessage(commandSender, new Object[0]);
            return;
        }
        Player player = (Player)commandSender;
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (!skilledPlayer.getSkillName().toLowerCase(Locale.ENGLISH).contains("priest")) {
            SkillsLang.COMMAND_MUSIC_PRIEST_ONLY.sendMessage(commandSender, new Object[0]);
            return;
        }
        SkillsLang.COMMAND_MUSIC_PLAYING.sendMessage(commandSender, new Object[0]);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            try {
                NoteBlockMusic.Sequence sequence = NoteBlockMusic.parseInstructions(String.join((CharSequence)" ", stringArray));
                sequence.play(player, () -> ((Player)player).getLocation(), true);
                SkillsLang.COMMAND_MUSIC_DONE.sendMessage(commandSender, new Object[0]);
            }
            catch (Throwable throwable) {
                SkillsLang.COMMAND_MUSICT_ERROR.sendMessage(commandSender, "%error%", throwable.getLocalizedMessage());
                throwable.printStackTrace();
            }
        });
    }

    @Override
    public @Nullable String[] tabComplete(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        return new String[]{MessageHandler.colorize("&2<instrument>&8,&6<note>&8,&9<repeat>&8,&5<repeatFermata> &7<Fermata>")};
    }
}

