/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.general;

import java.util.Map;
import java.util.Objects;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.skills.abilities.Ability;
import org.skills.abilities.ActiveAbility;
import org.skills.abilities.KeyBinding;
import org.skills.abilities.KeyBindingException;
import org.skills.commands.SkillsCommand;
import org.skills.data.managers.PlayerAbilityData;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.types.Skill;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

public class CommandKeyBinding
extends SkillsCommand {
    public CommandKeyBinding() {
        super("bindings", SkillsLang.COMMAND_BINDINGS_DESCRIPTION, "key", "binding");
    }

    @Override
    public void runCommand(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        KeyBinding[] keyBindingArray;
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
            return;
        }
        Player player = (Player)commandSender;
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        Skill skill = skilledPlayer.getSkill();
        if (skill.isNone()) {
            SkillsLang.COMMAND_BINDINGS_NO_CLASS.sendMessage(commandSender, new Object[0]);
            return;
        }
        if (stringArray.length < 2) {
            SkillsLang.COMMAND_BINDINGS_USAGE.sendMessage(commandSender, new Object[0]);
            return;
        }
        Ability ability = skill.getAbility(stringArray[0].toLowerCase());
        if (ability == null) {
            SkillsLang.COMMAND_BINDINGS_UNKNOWN_ABILITY.sendMessage(player, "%ability%", stringArray[0]);
            return;
        }
        if (ability.isPassive()) {
            SkillsLang.COMMAND_BINDINGS_NOT_ACTIVE_ABILITY.sendMessage(player, "%ability%", ability.getTitle(skilledPlayer));
            return;
        }
        Map<String, PlayerAbilityData> map = skilledPlayer.getAbilities();
        PlayerAbilityData playerAbilityData = map.get(ability.getName());
        ActiveAbility activeAbility = (ActiveAbility)ability;
        try {
            keyBindingArray = stringArray[1].equals("~") ? activeAbility.getActivationKey(skilledPlayer) : KeyBinding.parseBinding(stringArray[1]);
        }
        catch (KeyBindingException keyBindingException) {
            SkillsLang.COMMAND_BINDINGS_INVALID.sendMessage(player, "%binding%", stringArray[1]);
            return;
        }
        for (Map.Entry<String, PlayerAbilityData> entry : map.entrySet()) {
            Ability ability2 = Objects.requireNonNull(skill.getAbility(entry.getKey()), () -> "Unknown ability " + (String)entry.getKey() + " for " + skill.getName());
            if (ability2.isPassive() || ability == ability2) continue;
            ActiveAbility activeAbility2 = (ActiveAbility)ability2;
            KeyBinding[] keyBindingArray2 = entry.getValue().getKeyBinding();
            if (keyBindingArray2 == null) {
                keyBindingArray2 = activeAbility2.getActivationKey(skilledPlayer);
            }
            if (!KeyBinding.isIllegalBinding(keyBindingArray, keyBindingArray2)) continue;
            SkillsLang.COMMAND_BINDINGS_CONFLICT.sendMessage(player, "%binding%", KeyBinding.toString(keyBindingArray), "%other_binding%", KeyBinding.toString(keyBindingArray2), "%ability%", ability2.getName());
            return;
        }
        playerAbilityData.setKeyBinding(keyBindingArray);
        SkillsLang.COMMAND_BINDINGS_CHANGED.sendMessage(player, "%binding%", KeyBinding.toString(keyBindingArray), "%ability%", ability.getName());
    }

    @Override
    public @Nullable String[] tabComplete(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            return new String[0];
        }
        Player player = (Player)commandSender;
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (stringArray.length == 1) {
            return (String[])skilledPlayer.getSkill().getAbilities().stream().filter(ability -> !ability.isPassive()).map(Ability::getName).toArray(String[]::new);
        }
        if (stringArray.length == 2) {
            Ability ability2 = skilledPlayer.getSkill().getAbility(stringArray[0]);
            if (ability2 == null) {
                return new String[0];
            }
            if (ability2.isPassive()) {
                return new String[0];
            }
            ActiveAbility activeAbility = (ActiveAbility)ability2;
            PlayerAbilityData playerAbilityData = skilledPlayer.getAbilityData(activeAbility);
            KeyBinding[] keyBindingArray = playerAbilityData == null || playerAbilityData.getKeyBinding() == null ? activeAbility.getActivationKey(skilledPlayer) : playerAbilityData.getKeyBinding();
            return new String[]{"Current: " + KeyBinding.toString(keyBindingArray), "Default: " + KeyBinding.toString(activeAbility.getActivationKey(skilledPlayer)), "Type '~' to reset to default."};
        }
        return new String[0];
    }
}

