/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.general;

import java.util.Collection;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.data.managers.SkilledPlayer;
import org.skills.events.SkillsBonus;
import org.skills.events.SkillsEventType;
import org.skills.events.SkillsPersonalBonus;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;

public class CommandInfo
extends SkillsCommand {
    public CommandInfo() {
        super("info", SkillsLang.COMMAND_INFO_DESCRIPTION, false, "see", "show", "level", "xp", "exp", "lvl", "levels", "lvls", "who");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length != 0) {
            if (!commandSender.hasPermission("skills.command.info.others")) {
                SkillsLang.COMMAND_INFO_OTHERS_PERMISSION.sendMessage(commandSender, new Object[0]);
                return;
            }
            OfflinePlayer offlinePlayer = this.getPlayer(commandSender, stringArray[0]);
            if (offlinePlayer == null) {
                return;
            }
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(offlinePlayer);
            SkillsLang skillsLang = commandSender.hasPermission("skills.command.info.others.details") ? SkillsLang.COMMAND_INFO_MESSAGE : SkillsLang.COMMAND_INFO_OTHERS;
            skillsLang.sendMessage(commandSender, offlinePlayer, new Object[0]);
            String string = this.getBonusString(skilledPlayer);
            if (!string.isEmpty()) {
                MessageHandler.sendMessage(commandSender, string);
            }
            return;
        }
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
            SkillsLang.COMMAND_INFO_MESSAGE.sendMessage(player, (OfflinePlayer)player, new Object[0]);
            String string = this.getBonusString(skilledPlayer);
            if (!string.isEmpty()) {
                MessageHandler.sendMessage(commandSender, string);
            }
        } else {
            SkillsCommandHandler.sendUsage(commandSender, "info <player>");
        }
    }

    public String getBonusString(SkilledPlayer skilledPlayer) {
        Collection<SkillsPersonalBonus> collection = skilledPlayer.getBonuses();
        if (collection.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (SkillsBonus skillsBonus : collection) {
            SkillsLang skillsLang = skillsBonus.getType() == SkillsEventType.SOUL ? SkillsLang.COMMAND_INFO_SOUL_BONUS : SkillsLang.COMMAND_INFO_XP_BONUS;
            stringBuilder.append(skillsLang.parse(skilledPlayer.getOfflinePlayer()));
            if (collection.size() <= 1 || bl) continue;
            stringBuilder.append('\n');
            bl = true;
        }
        return stringBuilder.toString();
    }

    @Override
    public String[] tabComplete(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        return stringArray.length == 1 ? null : new String[]{};
    }
}

