/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.general;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.skills.abilities.Ability;
import org.skills.abilities.ActiveAbility;
import org.skills.abilities.KeyBinding;
import org.skills.commands.SkillsCommand;
import org.skills.data.managers.SkilledPlayer;
import org.skills.gui.GUIOption;
import org.skills.gui.GUIParser;
import org.skills.gui.InteractiveGUI;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;

public class CommandImprove
extends SkillsCommand {
    public CommandImprove() {
        super("improve", SkillsLang.COMMAND_IMPROVE_DESCRIPTION, "improvement", "improvements", "upgrade", "upgrades", "ability", "abilities");
    }

    public static void openMenu(Player player, SkilledPlayer skilledPlayer, int n, boolean bl) {
        Collection collection = skilledPlayer.getSkill().getAbilities();
        int n2 = collection.size() - 1;
        int n3 = n2 / 4;
        if (n2 % 4 != 0) {
            ++n3;
        }
        if (n2 > 4) {
            collection = collection.stream().filter(ability -> !ability.getName().endsWith("passive")).sorted(Comparator.comparingInt(ability -> ability.getRequiredLevel(skilledPlayer))).skip((long)n * 4L).limit(4L).collect(Collectors.toList());
            collection.add(skilledPlayer.getSkill().getAbilities().stream().filter(ability -> ability.getName().endsWith("passive")).findFirst().orElseThrow(() -> new IllegalStateException(skilledPlayer.getSkillName() + " skill has no passive ability.")));
        } else {
            n3 = 1;
        }
        int n4 = n3;
        InteractiveGUI interactiveGUI = GUIParser.parseOption(player, "abilities", "%page%", n + 1, "%pages%", n3);
        interactiveGUI.push("previous-page", () -> {
            if (n == 0) {
                XSound.BLOCK_NOTE_BLOCK_BASS.record().soundPlayer().forPlayers(player).play();
                return;
            }
            CommandImprove.openMenu(player, skilledPlayer, n - 1, true);
            XSound.ITEM_BOOK_PAGE_TURN.play((Entity)player);
        }, new Object[0]);
        interactiveGUI.push("next-page", () -> {
            if (n + 2 > n4) {
                XSound.BLOCK_NOTE_BLOCK_BASS.record().soundPlayer().forPlayers(player).play();
                return;
            }
            CommandImprove.openMenu(player, skilledPlayer, n + 1, true);
            XSound.ITEM_BOOK_PAGE_TURN.play((Entity)player);
        }, new Object[0]);
        ArrayList<Integer> arrayList = null;
        int n5 = -1;
        for (Ability ability2 : collection) {
            int[] nArray;
            Object[] objectArray4;
            boolean bl2 = ability2.getName().endsWith("passive");
            boolean bl3 = ability2.isPassive();
            int n6 = skilledPlayer.getAbilityLevel(ability2);
            ActiveAbility activeAbility = bl3 ? null : (ActiveAbility)ability2;
            KeyBinding[] keyBindingArray = skilledPlayer.getAbilityData(ability2).getKeyBinding();
            Object[] objectArray2 = new Object[16];
            objectArray2[0] = "%required-level%";
            objectArray2[1] = ability2.getRequiredLevel(skilledPlayer);
            objectArray2[2] = "%title%";
            objectArray2[3] = ability2.getTitle(skilledPlayer);
            objectArray2[4] = "%level%";
            objectArray2[5] = n6;
            objectArray2[6] = "%disabled%";
            objectArray2[7] = skilledPlayer.isAbilityDisabled(ability2);
            objectArray2[8] = "%cost%";
            objectArray2[9] = ability2.getCost(skilledPlayer);
            objectArray2[10] = "%activation_cooldown%";
            objectArray2[11] = activeAbility == null ? "" : Double.valueOf(activeAbility.getCooldown(skilledPlayer));
            objectArray2[12] = "%activation_energy%";
            objectArray2[13] = activeAbility == null ? "" : Double.valueOf(activeAbility.getEnergy(skilledPlayer));
            objectArray2[14] = "%activation_key%";
            objectArray2[15] = KeyBinding.toString(keyBindingArray == null ? (activeAbility == null ? new KeyBinding[]{} : activeAbility.getActivationKey(skilledPlayer)) : keyBindingArray);
            Object[] objectArray3 = objectArray2;
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>(interactiveGUI.getHolder("ability", objectArray3).getSlots());
                n5 = interactiveGUI.getHolder("passive", objectArray3).getSlots().get(0);
            }
            String string = bl3 ? (bl2 ? "passive" : "ability") : "active-ability";
            GUIOption gUIOption = interactiveGUI.getHolder(string, objectArray3);
            ItemStack itemStack = gUIOption.getItem();
            ItemMeta itemMeta = gUIOption.getItem().getItemMeta();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Object[] objectArray4 : itemMeta.getLore()) {
                if (Strings.isNullOrEmpty((String)objectArray4)) continue;
                objectArray4 = MessageHandler.replace((String)objectArray4, "%description%", () -> ability2.getDescription(skilledPlayer));
                String string2 = "";
                for (String string3 : StringUtils.splitPreserveAllTokens((String)objectArray4, (char)'\n')) {
                    if (string3.isEmpty()) {
                        arrayList2.add(" ");
                        continue;
                    }
                    string3 = string2 + MessageHandler.colorize(string3);
                    arrayList2.add(string3);
                    string2 = ChatColor.getLastColors((String)string3);
                }
            }
            itemMeta.setLore(arrayList2);
            gUIOption.getItem().setItemMeta(itemMeta);
            List<Object> list = ability2.getEdits(skilledPlayer);
            for (Object object : objectArray3) {
                list.add(object);
            }
            objectArray4 = list.toArray();
            gUIOption.defineVariables(interactiveGUI, list);
            int n7 = bl2 ? n5 : arrayList.remove(0);
            interactiveGUI.push(gUIOption, itemStack, n7, objectArray4, null, new InteractiveGUI.ActionRunnable(ClickType.LEFT, () -> {
                if (bl2 || skilledPlayer.getAbilityLevel(ability2) >= 3) {
                    skilledPlayer.toggleAbility(ability2);
                    CommandImprove.openMenu(player, skilledPlayer, n, true);
                    XSound.BLOCK_END_PORTAL_FRAME_FILL.play((Entity)player);
                    return;
                }
                int n2 = ability2.getRequiredLevel(skilledPlayer);
                if (n2 > skilledPlayer.getLevel()) {
                    SkillsLang.ABILITY_REQUIRED_LEVEL.sendMessage(player, "%level%", n2);
                    XSound.BLOCK_NOTE_BLOCK_BASS.record().soundPlayer().forPlayers(player).play();
                    return;
                }
                int n3 = ability2.getCost(skilledPlayer);
                long l = skilledPlayer.getSouls();
                if (l >= (long)n3) {
                    skilledPlayer.addAbilityLevel(ability2, 1);
                    skilledPlayer.setSouls(l - (long)n3);
                    SkillsLang.ABILITY_UPGRADED.sendMessage(player, new Object[0]);
                    XSound.BLOCK_ANVIL_USE.play((Entity)player);
                    CommandImprove.openMenu(player, skilledPlayer, n, true);
                } else {
                    SkillsLang.NOT_ENOUGH_SOULS.sendMessage(player, new Object[0]);
                    XSound.BLOCK_NOTE_BLOCK_BASS.record().soundPlayer().forPlayers(player).play();
                }
            }), new InteractiveGUI.ActionRunnable(ClickType.RIGHT, () -> {
                int n2;
                if (skilledPlayer.getAbilityLevel(ability2) == 0 && (n2 = ability2.getRequiredLevel(skilledPlayer)) > skilledPlayer.getLevel()) {
                    SkillsLang.ABILITY_REQUIRED_LEVEL.sendMessage(player, "%level%", n2);
                    XSound.BLOCK_NOTE_BLOCK_BASS.record().soundPlayer().forPlayers(player).play();
                    return;
                }
                skilledPlayer.toggleAbility(ability2);
                XSound.BLOCK_END_PORTAL_FRAME_FILL.play((Entity)player);
                CommandImprove.openMenu(player, skilledPlayer, n, true);
            }));
            if (bl2) continue;
            for (int n8 : nArray = new int[]{n7 + 1, n7 + 2, n7 + 3}) {
                if (n6 == 3) {
                    interactiveGUI.getInventory().setItem(n8, CommandImprove.getDecal(XMaterial.GREEN_STAINED_GLASS_PANE));
                    continue;
                }
                if (n6 > 0) {
                    --n6;
                    interactiveGUI.getInventory().setItem(n8, CommandImprove.getDecal(XMaterial.ORANGE_STAINED_GLASS_PANE));
                    continue;
                }
                interactiveGUI.getInventory().setItem(n8, CommandImprove.getDecal(XMaterial.BLACK_STAINED_GLASS_PANE));
            }
            if (n6 == 3) {
                interactiveGUI.getInventory().setItem(n7 + 4, CommandImprove.getDecal(XMaterial.BLUE_STAINED_GLASS_PANE));
                continue;
            }
            interactiveGUI.getInventory().setItem(n7 + 4, CommandImprove.getDecal(XMaterial.GRAY_STAINED_GLASS_PANE));
        }
        interactiveGUI.dispose("ability", "active-ability", "passive");
        interactiveGUI.setRest();
        interactiveGUI.openInventory(player, bl);
    }

    private static ItemStack getDecal(XMaterial xMaterial) {
        ItemStack itemStack = xMaterial.parseItem();
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(" ");
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
            if (!skilledPlayer.hasSkill()) {
                SkillsLang.NO_SKILL.sendMessage(player, new Object[0]);
                return;
            }
            CommandImprove.openMenu(player, skilledPlayer, 0, false);
        } else {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
        }
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        return new String[0];
    }
}

