/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.general;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.HoverLang;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandHelp
extends SkillsCommand {
    public CommandHelp() {
        super("help", SkillsLang.COMMAND_HELP_DESCRIPTION, false, "h", "?");
    }

    public static int getPageNumbers(List<SkillsCommand> list) {
        return list.size() % 5 != 0 ? list.size() / 5 + 1 : list.size() / 5;
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        int n = 0;
        if (stringArray.length >= 1) {
            try {
                n = Integer.parseInt(stringArray[0]) - 1;
                if (n + 1 < 1) {
                    SkillsLang.COMMAND_HELP_NEGATIVE_PAGES.sendMessage(commandSender, new Object[0]);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.sendUsage(commandSender, SkillsLang.COMMAND_HELP_USAGE);
                return;
            }
        }
        List<SkillsCommand> list = Arrays.asList((SkillsCommand[])SkillsCommandHandler.getCommands().stream().filter(skillsCommand -> skillsCommand.hasPermission(commandSender)).toArray(SkillsCommand[]::new));
        int n2 = SkillsConfig.COMMANDS_EACH_PAGE.getInt();
        List list2 = list.stream().skip((long)n * (long)n2).collect(Collectors.toList());
        if (list2.isEmpty()) {
            return;
        }
        int n3 = CommandHelp.getPageNumbers(list);
        SkillsLang.COMMAND_HELP_HEADER.sendMessage(commandSender, "%previous_page%", n, "%page%", n + 1, "%next_page%", n + 2, "%max_pages%", n3);
        list2.stream().limit(n2).forEach(skillsCommand -> {
            StringBuilder stringBuilder = new StringBuilder(skillsCommand.getName());
            for (SkillsCommand skillsCommand2 = skillsCommand.getGroup(); skillsCommand2 != null; skillsCommand2 = skillsCommand2.getGroup()) {
                stringBuilder.insert(0, skillsCommand2.getName() + ' ');
            }
            SkillsLang.COMMAND_HELP_COMMANDS.sendMessage(commandSender, "%cmd%", stringBuilder.toString(), "%description%", skillsCommand.getDescription());
        });
        HoverLang.ComplexComponent complexComponent = new HoverLang.ComplexComponent(SkillsLang.COMMAND_HELP_FOOTER_PAGE.getLang());
        OfflinePlayer offlinePlayer = commandSender instanceof Player ? (OfflinePlayer)commandSender : null;
        for (int i = 1; i <= CommandHelp.getPageNumbers(list); ++i) {
            if (i == n + 1) {
                complexComponent.append(SkillsLang.COMMAND_HELP_FOOTER_CURRENT_PAGE.getLang(), offlinePlayer, "%number%", i, "%previous_page%", n, "%page%", n + 1, "%next_page%", n + 2, "%max_pages%", n3);
            } else {
                complexComponent.append(offlinePlayer, "%number%", i, "%previous_page%", n, "%page%", n + 1, "%next_page%", n + 2, "%max_pages%", n3);
            }
            complexComponent.append(" ");
        }
        SkillsLang.COMMAND_HELP_FOOTER.sendMessage(commandSender, complexComponent.asComplexEdit("%pages%"), "%previous_page%", n, "%page%", n + 1, "%next_page%", n + 2, "%max_pages%", n3);
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<SkillsCommand> list = Arrays.asList((SkillsCommand[])SkillsCommandHandler.getCommands().stream().filter(skillsCommand -> skillsCommand.hasPermission(commandSender)).toArray(SkillsCommand[]::new));
        for (int i = CommandHelp.getPageNumbers(list); i > 0; --i) {
            arrayList.add(String.valueOf(i));
        }
        return arrayList.toArray(new String[0]);
    }
}

