/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.general;

import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandHPScaling
extends SkillsCommand {
    public CommandHPScaling() {
        super("hpscaling", null, SkillsLang.COMMAND_SCALING_DESCRIPTION, "scaling", "healthscaling", "hp", "health");
    }

    @Override
    public void runCommand(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        double d;
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendMessage(commandSender, new Object[0]);
            return;
        }
        if (stringArray.length < 1) {
            SkillsCommandHandler.sendUsage(commandSender, "<scale>");
            return;
        }
        String string = stringArray[0];
        try {
            d = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            SkillsLang.Command_Not_Number.sendMessage(commandSender, "%args%", string, "%needed%", "Health Scaling");
            return;
        }
        if (d < 0.0 || d > 80.0) {
            SkillsLang.COMMAND_SCALING_NOT_IN_RANGE.sendMessage(commandSender, new Object[0]);
            return;
        }
        Player player = (Player)commandSender;
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        skilledPlayer.setHealthScaling(d);
        skilledPlayer.setScaledHealth();
        SkillsLang.COMMAND_SCALING_SET.sendMessage(player, "%scale%", d);
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        return new String[]{"0-80"};
    }
}

