/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.friends;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.friends.CommandFriendAccept;
import org.skills.data.managers.SkilledPlayer;
import org.skills.gui.GUIOption;
import org.skills.gui.GUIParser;
import org.skills.gui.InteractiveGUI;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.xseries.profiles.builder.XSkull;
import org.skills.utils.xseries.profiles.objects.Profileable;

public class CommandFriends
extends SkillsCommand {
    public CommandFriends() {
        super("friends", SkillsLang.COMMAND_FRIENDS_DESCRIPTION, new String[0]);
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
            return;
        }
        Player player = (Player)commandSender;
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        InteractiveGUI interactiveGUI = GUIParser.parseOption(player, "friends");
        List<Integer> list = interactiveGUI.getHolder("friend", new Object[0]).getSlots();
        for (OfflinePlayer offlinePlayer : skilledPlayer.getPlayerFriends()) {
            GUIOption gUIOption = interactiveGUI.getHolder("friend", new Object[0]);
            ItemStack itemStack = gUIOption.getItem();
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta instanceof SkullMeta) {
                XSkull.of(itemMeta).profile(Profileable.of(offlinePlayer)).apply();
            } else {
                MessageHandler.sendConsolePluginMessage("&4Cannot set friend skin on an item that is not a skull&8: &e" + itemStack);
            }
            itemStack.setItemMeta(itemMeta);
            GUIOption.defineVariables(itemStack, offlinePlayer, new Object[0]);
            int n = list.remove(0);
            interactiveGUI.push(gUIOption, itemStack, n, () -> {
                if (!SkillsConfig.FRIENDS_TELEPORT_ENABLED.getBoolean()) {
                    return;
                }
                if (!player.hasPermission("skills.command.friendtp")) {
                    SkillsLang.COMMAND_FRIENDS_TELEPORT_PERMISSION.sendMessage(player, "%name%", offlinePlayer.getName());
                    return;
                }
                if (!offlinePlayer.isOnline()) {
                    SkillsLang.COMMAND_FRIENDS_TELEPORT_NOT_ONLINE.sendMessage(player, "%name%", offlinePlayer.getName());
                    return;
                }
                Player player2 = (Player)offlinePlayer;
                if (player.hasPermission("skills.command.friendtp.instant")) {
                    player.teleport((Entity)player2);
                    SkillsLang.COMMAND_FRIENDTP_TELEPORTED.sendMessage(player, "%friend%", player2.getName());
                    SkillsLang.COMMAND_FRIENDTP_NOTIFY.sendMessage(player2, "%friend%", player.getName());
                    return;
                }
                Set set = CommandFriendAccept.requests.getOrDefault(offlinePlayer.getUniqueId(), new HashSet());
                CommandFriendAccept.Teleportation teleportation2 = set.stream().filter(teleportation -> teleportation.from.equals(player.getUniqueId())).findFirst().orElse(null);
                if (teleportation2 != null) {
                    SkillsLang.COMMAND_FRIENDTP_ALREADY_REQUESTED.sendMessage(player, "%friend%", offlinePlayer.getName());
                    return;
                }
                SkillsLang.COMMAND_FRIENDTP_REQUESTED.sendMessage(player, "%friend%", player2.getName());
                SkillsLang.COMMAND_FRIENDTP_NOTIFY_REQUEST.sendMessage(player2, "%friend%", player.getName());
                int n = SkillsConfig.FRIENDS_TELEPORT_REQUEST_TIME.getInt();
                int n2 = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    Set set = CommandFriendAccept.requests.getOrDefault(player2.getUniqueId(), new HashSet());
                    CommandFriendAccept.Teleportation teleportation2 = set.stream().filter(teleportation -> teleportation.from.equals(player.getUniqueId())).findFirst().orElse(null);
                    if (teleportation2 != null) {
                        if (player.isOnline()) {
                            SkillsLang.COMMAND_FRIENDTP_EXPIRED.sendMessage(player, "%friend%", player2.getName());
                        }
                        if (player2.isOnline()) {
                            SkillsLang.COMMAND_FRIENDTP_EXPIRED_NOTIFY.sendMessage(player2, "%friend%", player.getName());
                        }
                        set.remove(teleportation2);
                        if (set.isEmpty()) {
                            CommandFriendAccept.requests.remove(player2.getUniqueId());
                        } else {
                            CommandFriendAccept.requests.put(player2.getUniqueId(), set);
                        }
                    }
                }, (long)n * 20L).getTaskId();
                set.add(new CommandFriendAccept.Teleportation(player.getUniqueId(), n2));
                CommandFriendAccept.requests.put(player.getUniqueId(), set);
            }, "%name%", offlinePlayer.getName(), "%online%", MessageHandler.colorize(offlinePlayer.isOnline() ? "&2Online" : "&cOffline"));
        }
        interactiveGUI.dispose("friend");
        interactiveGUI.setRest();
        interactiveGUI.openInventory(player);
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        return new String[0];
    }
}

