/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.friends;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.commands.friends.CommandFriendAccept;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandFriendTeleport
extends SkillsCommand {
    public CommandFriendTeleport() {
        super("friendtp", SkillsLang.COMMAND_FRIENDTP_DESCRIPTION, "tp", "tpfriend", "teleport");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
            return;
        }
        if (stringArray.length < 1) {
            SkillsCommandHandler.sendUsage(commandSender, "friendtp <player>");
            return;
        }
        Player player = (Player)commandSender;
        if (!SkillsConfig.FRIENDS_TELEPORT_ENABLED.getBoolean()) {
            SkillsLang.COMMAND_FRIENDTP_DISABLED.sendMessage(player, new Object[0]);
            return;
        }
        Player player2 = Bukkit.getPlayer((String)stringArray[0]);
        if (player2 == null) {
            SkillsLang.PLAYER_NOT_FOUND.sendMessage(player, "%name%", stringArray[0]);
            return;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (!skilledPlayer.getFriends().contains(player2.getUniqueId())) {
            SkillsLang.COMMAND_FRIENDTP_NOT_FRIENDS.sendMessage(player, "%name%", player2.getName());
            return;
        }
        if (player.hasPermission("skills.command.friendtp.instant")) {
            player.teleport((Entity)player2);
            SkillsLang.COMMAND_FRIENDTP_TELEPORTED.sendMessage(player, "%friend%", player2.getName());
            SkillsLang.COMMAND_FRIENDTP_NOTIFY.sendMessage(player2, "%friend%", player.getName());
            return;
        }
        Set set = CommandFriendAccept.requests.getOrDefault(player2.getUniqueId(), new HashSet());
        if (set.stream().anyMatch(teleportation -> teleportation.from.equals(player.getUniqueId()))) {
            SkillsLang.COMMAND_FRIENDTP_ALREADY_REQUESTED.sendMessage(player, "%friend%", player2.getName());
            return;
        }
        SkillsLang.COMMAND_FRIENDTP_REQUESTED.sendMessage(player, "%friend%", player2.getName());
        SkillsLang.COMMAND_FRIENDTP_NOTIFY_REQUEST.sendMessage(player2, "%friend%", player.getName());
        int n = SkillsConfig.FRIENDS_TELEPORT_REQUEST_TIME.getInt();
        int n2 = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Set set = CommandFriendAccept.requests.getOrDefault(player2.getUniqueId(), new HashSet());
            CommandFriendAccept.Teleportation teleportation2 = set.stream().filter(teleportation -> teleportation.from.equals(player.getUniqueId())).findFirst().orElse(null);
            if (teleportation2 != null) {
                if (player.isOnline()) {
                    SkillsLang.COMMAND_FRIENDTP_EXPIRED.sendMessage(player, "%friend%", player2.getName());
                }
                if (player2.isOnline()) {
                    SkillsLang.COMMAND_FRIENDTP_EXPIRED_NOTIFY.sendMessage(player2, "%friend%", player.getName());
                }
                set.remove(teleportation2);
                if (set.isEmpty()) {
                    CommandFriendAccept.requests.remove(player2.getUniqueId());
                } else {
                    CommandFriendAccept.requests.put(player2.getUniqueId(), set);
                }
            }
        }, (long)n * 20L).getTaskId();
        set.add(new CommandFriendAccept.Teleportation(player.getUniqueId(), n2));
        CommandFriendAccept.requests.put(player2.getUniqueId(), set);
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (commandSender instanceof Player) {
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(((Player)commandSender).getUniqueId());
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (player.getUniqueId().equals(((Player)commandSender).getUniqueId()) || !skilledPlayer.getFriends().contains(player.getUniqueId())) continue;
                arrayList.add(player.getName());
            }
            return arrayList.toArray(new String[0]);
        }
        return new String[0];
    }
}

