/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.friends;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.LocationUtils;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandFriendAccept
extends SkillsCommand
implements Listener {
    protected static final Map<UUID, Set<Teleportation>> requests = new HashMap<UUID, Set<Teleportation>>();
    private static final Map<UUID, Teleportation> teleporting = new HashMap<UUID, Teleportation>();

    public CommandFriendAccept() {
        super("tpaccept", SkillsLang.COMMAND_TPACCEPT_DESCRIPTION, "accepttp", "tpa");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        Player player;
        Teleportation teleportation2;
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
            return;
        }
        final Player player2 = (Player)commandSender;
        Set<Teleportation> set = requests.get(player2.getUniqueId());
        if (set == null) {
            SkillsLang.COMMAND_TPACCEPT_NO_REQUESTS.sendMessage(player2, new Object[0]);
            return;
        }
        if (stringArray.length == 0) {
            if (set.size() > 1) {
                SkillsLang.COMMAND_TPACCEPT_MORE_THAN_ONE.sendMessage(player2, new Object[0]);
                return;
            }
            teleportation2 = set.iterator().next();
            player = Bukkit.getPlayer((UUID)teleportation2.from);
            if (player == null) {
                SkillsLang.COMMAND_TPACCEPT_OFFLINE.sendMessage(player2, "%friend%", stringArray[0]);
                requests.remove(player2.getUniqueId());
                return;
            }
        } else {
            player = Bukkit.getPlayer((String)stringArray[0]);
            if (player == null) {
                SkillsLang.PLAYER_NOT_FOUND.sendMessage(player2, "%name%", stringArray[0]);
                return;
            }
            teleportation2 = set.stream().filter(teleportation -> teleportation.from.equals(player.getUniqueId())).findFirst().orElse(null);
            if (teleportation2 == null) {
                SkillsLang.COMMAND_TPACCEPT_NO_REQUEST.sendMessage(player2, "%name%", player.getName());
                return;
            }
            if (set.size() == 1) {
                requests.remove(player2.getUniqueId());
            }
        }
        Bukkit.getScheduler().cancelTask(teleportation2.task);
        final int n = SkillsConfig.FRIENDS_TELEPORT_TIMER.getInt();
        if (n <= 0) {
            player.teleport((Entity)player2);
            SkillsLang.COMMAND_TPACCEPT_TELEPORTED.sendMessage(player, "%friend%", player2.getName());
            SkillsLang.COMMAND_TPACCEPT_NOTIFY.sendMessage(player2, "%friend%", player.getName());
            return;
        }
        int n2 = SkillsConfig.FRIENDS_TELEPORT_DELAY_BEFORE_MOVE_CHECK.getInt();
        n2 = Math.max(0, n2);
        SkillsLang.COMMAND_TPACCEPT_TELEPORT_START.sendMessage(player, "%delay%", n2);
        SkillsLang.COMMAND_TPACCEPT_PRE_NOTIFY.sendMessage(player2, "%friend%", player.getName());
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            int n2 = new BukkitRunnable(){
                int timed;
                {
                    this.timed = n;
                }

                public void run() {
                    if (!player2.isOnline()) {
                        SkillsLang.COMMAND_TPACCEPT_DISCONNECTED.sendMessage(player2, new Object[0]);
                        teleporting.remove(player.getUniqueId());
                        this.cancel();
                        return;
                    }
                    if (this.timed <= 0) {
                        teleporting.remove(player.getUniqueId());
                        player.teleport((Entity)player2);
                        SkillsLang.COMMAND_TPACCEPT_TELEPORTED.sendMessage(player, "%friend%", player2.getName());
                        SkillsLang.COMMAND_TPACCEPT_NOTIFY.sendMessage(player2, "%friend%", player.getName());
                        this.cancel();
                    } else {
                        SkillsLang.COMMAND_TPACCEPT_TELEPORTING.sendMessage(player, "%countdown%", this.timed);
                    }
                    --this.timed;
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 20L).getTaskId();
            teleporting.put(player.getUniqueId(), new Teleportation(player2.getUniqueId(), n2));
        }, (long)n2 * 20L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamage(EntityDamageEvent entityDamageEvent) {
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        Teleportation teleportation = teleporting.remove(player.getUniqueId());
        if (teleportation != null) {
            Bukkit.getScheduler().cancelTask(teleportation.task);
            Player player2 = Bukkit.getPlayer((UUID)teleportation.from);
            SkillsLang.COMMAND_TPACCEPT_CANCELED.sendMessage(player, "%friend%", player2.getName());
            if (player2 != null) {
                SkillsLang.COMMAND_TPACCEPT_CANCELED_NOTIFY.sendMessage(player2, "%friend%", player.getName());
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onMove(PlayerMoveEvent playerMoveEvent) {
        if (!SkillsConfig.FRIENDS_TELEPORT_SHOULD_NOT_MOVE.getBoolean()) {
            return;
        }
        if (!LocationUtils.hasMoved(playerMoveEvent.getFrom(), playerMoveEvent.getTo())) {
            return;
        }
        Player player = playerMoveEvent.getPlayer();
        Teleportation teleportation = teleporting.remove(player.getUniqueId());
        if (teleportation != null) {
            Bukkit.getScheduler().cancelTask(teleportation.task);
            Player player2 = Bukkit.getPlayer((UUID)teleportation.from);
            SkillsLang.COMMAND_TPACCEPT_CANCELED.sendMessage(player, "%friend%", player2.getName());
            if (player2 != null) {
                SkillsLang.COMMAND_TPACCEPT_CANCELED_NOTIFY.sendMessage(player2, "%friend%", player.getName());
            }
        }
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        Player player;
        Set<Teleportation> set;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (commandSender instanceof Player && (set = requests.get((player = (Player)commandSender).getUniqueId())) != null) {
            for (Teleportation teleportation : set) {
                Player player2 = Bukkit.getPlayer((UUID)teleportation.from);
                if (player2 == null) continue;
                arrayList.add(player2.getName());
            }
            return arrayList.toArray(new String[0]);
        }
        return new String[0];
    }

    protected static class Teleportation {
        protected final UUID from;
        protected final int task;

        protected Teleportation(UUID uUID, int n) {
            this.from = uUID;
            this.task = n;
        }
    }
}

